import {
    Column,
    Entity,
    PrimaryGeneratedColumn,
    CreateDateColumn,
    BaseEntity,
    ManyToOne,
    OneToOne,
    JoinTable,
    OneToMany
  } from 'typeorm';
  import {User} from './User';
  import {Project} from './Project';
import { DateTimeTask } from './DateTimeTask';

  export type taskFinishType = "opened"| "progress"  | "done" |"failed";
  export type priorityType = "A" | "B" |"C";

  interface ITask{
    id: string;
    title: string;
    description: string;
    note: string;
    createdAt: Date;
    dateTimeDeadLine: Date| null;
    dateTimeFactDeadLine: Date| null;
    accomplish: taskFinishType;
    priority: priorityType | null;
    archive:boolean,
    author: User;
    project:Project|null;
    dateTimeTasks:DateTimeTask[]|null;
    executor:User;
  }

  @Entity({ name: 'Task' })
  export class Task extends BaseEntity implements ITask{
    @PrimaryGeneratedColumn('uuid')
    id!: string
    @Column({ name: 'title', type: 'varchar', length:50,nullable: false })
    title!: string
    @Column({ name: 'description', type: 'varchar', length:50,nullable: true })
    description!: string
    @Column({ name: 'note', type: 'varchar', length:100,nullable: true })
    note!: string
    @CreateDateColumn({ name: 'created_at', type: Date, default: new Date() })
    createdAt!: Date;
    @Column({ name: 'dateTimeDeadLine', type: Date,nullable: true })
    dateTimeDeadLine!: Date;
    @Column({ name: 'dateTimeFactDeadLine', type: Date,nullable: true })
    dateTimeFactDeadLine!: Date;
    @Column({ name: 'archive', type: 'varchar', length:50,nullable: false, default:false })
    archive!: boolean

    @Column({
        type: "enum",
        enum: ["opened", "done" , "failed"],
        default: "opened"
      })
      accomplish!: taskFinishType

     
    @Column({
      type: "enum",
      enum: ["A", "B" , "C"],
      default: "C",
      nullable: true
    })
    priority!: priorityType | null;

    

    @ManyToOne(() => User, (user: { tasks: Task[]; }) => user.tasks,{eager : true})
      author!: User;

    @ManyToOne(() =>User, (user: { tasks: Task[]}) => user.tasks,{eager : true,nullable: true, onUpdate:'CASCADE'})
    @JoinTable()
    executor!: User;
    
    @ManyToOne(()=>Project,(project:{tasks: Task[]}) => project.tasks,{eager : true,nullable: true,onUpdate:'CASCADE'})
    project!: Project;

    @OneToMany(() => DateTimeTask, (dateTimeTask: { task: Task }) => dateTimeTask.task,{eager : true,nullable: true,onUpdate:'CASCADE'})
    dateTimeTasks!: DateTimeTask[];
  }
