import express, { NextFunction, Request, Response, Router } from "express";
import { myDataSource } from "./app-data-source";
import { Task } from "./models/Task";
import { User } from "./models/User";

const dataSource = myDataSource;

/** Check if user with given token exists , return user */
export const auth = async(req: Request,res: Response, next:NextFunction):Promise<void | express.Response<Response>>=>{
    const token = req.get('Authorization');
    if(!token) return res.status(401).send({Message:'token not exists'})
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.token = :token", { token: token })
    .getOne();
    if (!user) return res.status(404).send({Message:'user not found'})
    req.body={...req.body,user:user}
    next()
};

/**Check if user with the given token is executor or author of task with the given Id(taskId) */
export const authAuthorOrExecutorOfTask = async(req: Request,res: Response, next:NextFunction):Promise<void | express.Response<Response>>=>{
    const token = req.get('Authorization');
    const {taskId} = req.body
    if(!token) return res.status(401).send({Message:'token not exists'})
    req.body={...req.body,executorStatus:false}
    req.body={...req.body,authorStatus:false}

    const executor = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .leftJoinAndSelect("user.tasks", "task")
    .where("user.token = :token", { token: token })
    .getOne();
    console.log('executor', executor)
    if (executor) {
        req.body={...req.body,executorStatus:true}
    } 
    const author = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .leftJoinAndSelect("user.createdTasks", "task")
    .where("user.token = :token", { token: token })
    .getOne();
    console.log('author', author)
    if (author) {
        req.body={...req.body,authorStatus:true}
    }
    if(!author && !executor)return res.status(401).send({Message:'user is not authorized'})
    next()
};

/**task finder by id, return one task */
export const taskFinderById = async (taskId:string):Promise<null | Task>=>{
    const task = await dataSource
    .getRepository(Task)
    .findOne({
        relations:{
            executor:true,
            author:true,
            dateTimeTasks:true
        },
        where:{
            id:taskId
        }
    })
    return task
}