
import { Box, Typography } from '@mui/material';
import { memo } from 'react';
import MonthDecrementButton from './MonthDecrementButton/MonthDecrementButton';
import MonthIncrementButton from './MonthIncrementButton/MonthIncrementButton';
function MonthAndYearInfo({getCurrentMonthString, year, incrementMonth, decrementMonth}) {
  
  return ( 
  <>
    <Box
        sx={{ 
          flexGrow: 1, 
          display: 'flex',
          alignItems: 'center',
          gap: '10px'
        }}
        >
          <MonthDecrementButton
            decrementMonth={decrementMonth}
          />
          <Box sx={{ flexBasis: '150px' }}>
            <Typography
              variant="h6" 
              sx={{  
                display: 'flex',
                justifyContent: 'center',
              }}
            >
              {getCurrentMonthString}
            </Typography>
            <Typography align='center'>{year}</Typography>
          </Box>
          <MonthIncrementButton
            incrementMonth={incrementMonth}
          />   
      </Box>
  </> );
}

export default memo(MonthAndYearInfo);