import { Grid, TextField, Typography } from "@mui/material";
import React, { memo, useState, useEffect} from "react";

const CalendarTask = ({year, month, tasks, day, hours, setCurrentTask, hourFormat, handleOpen, currentTask}) => {
  const [thisCellCurrentTask, setThisCellCurrentTask] = useState({})
  const getTaskInDayCell = (tasks, day, hours) => {
    const hour = parseInt(hours.split(':')[0])
    let hourDiffEnd
    if (hourFormat) {
      hourDiffEnd = hour + 1
    } else {
      hourDiffEnd = hour + 2
    }
    const tasksCell = tasks.filter(task=> {
    if (year === task.infoForCell.startYear) {
      if (month + 1 === task.infoForCell.startMonth) {
        if (day.dayNumber === task.infoForCell.startDay) {
          if (((task.infoForCell.endHour <= hour || task.infoForCell.startHour <= hour) && (task.infoForCell.endHour > hour))  
          || (task.infoForCell.startHour >= hour  && task.infoForCell.endHour < hourDiffEnd)
          || (task.infoForCell.endMinute <= 59 && task.infoForCell.endHour === hour)) {
              return task
          }
        }
      }      
    }
    })
    return tasksCell
  }
  const tasksCell = getTaskInDayCell(tasks, day, hours)

  useEffect(()=>{
    if (!currentTask.title) {
      setThisCellCurrentTask({})
    }
  }, [currentTask])


  return (<> 
      {tasksCell.length ? tasksCell.map((task, i)=>
      {
      return (
      <Grid  
        key={task.id} 
        sx={{backgroundColor: 'lightgreen', whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis', padding: '10px',  borderBottom: '1px solid rgb(29, 161, 51);;'}} 
        onClick={(e)=>{e.stopPropagation(); setCurrentTask(task); handleOpen(e)}}
        >
          {task.title}
      </Grid>
      )}
      ) 
      : null}
  </>)
};

export default memo(CalendarTask);