import {Button, Menu, MenuItem} from "@mui/material";
import { useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import {NavLink, useNavigate} from "react-router-dom";
import { logoutUser } from "../../../store/actions/usersActions";

const AdminMenu = () => {
    const dispatch = useDispatch();
    const navigate = useNavigate()
    const [anchorEl, setAnchorEl] = useState(null);
    const open = Boolean(anchorEl);
    const user = useSelector(state => state.users.user)
    console.log(user)
    const handleClick = (event) => {
        setAnchorEl(event.currentTarget);
    };
    const handleClose = () => {
        setAnchorEl(null);
    };

    const logout = () => {
        dispatch(logoutUser(navigate));
        handleClose()
    }
    return <>
     <Button
            component={NavLink}
            to="/projects"
            color="inherit"
            size="large"
        >
            Проекты
        </Button>
        <Button
            component={NavLink}
            to="/week"
            color="inherit"
            size="large"
        >
            Неделя
        </Button>
        <Button
            component={NavLink}
            to="/month"
            color="inherit"
            size="large"
        >
            Месяц
        </Button>
        <Button
            component={NavLink}
            to="/my-tasks"
            color="inherit"
            size="large"
        >
            Мои задачи
        </Button>
        <Button
            component={NavLink}
            to="/workers-tasks"
            color="inherit"
            size="large"
        >
            Задачи сотрудников
        </Button>
        <Button
            component={NavLink}
            to="/sign-up"
            color="inherit"
            size="large"
        >
            Создать сотрудника
        </Button>
        <Button
            color="inherit"
            onClick={handleClick}
        >
            Hello, {user?.displayName}
        </Button>
        <Menu
            anchorEl={anchorEl}
            open={open}
            onClose={handleClose}

        >
            <MenuItem component={NavLink} to="/profile/test" color="inherit" onClick={handleClose}>Profile</MenuItem>
            <MenuItem onClick={logout}>Logout</MenuItem>
        </Menu>
    </>
};

export default AdminMenu;