import express,{Router, Request, Response} from 'express';
import {User} from '../models/User';
import {myDataSource} from '../app-data-source';
import { nanoid } from 'nanoid';
import multer  from 'multer';
import path from 'path';
import {config} from "../config"

const router:Router = express.Router();
const dataSource = myDataSource;


type DestinationCallback = (error: Error | null, destination: string) => void
type FileNameCallback = (error: Error | null, filename: string) => void

const storage = multer.diskStorage({
    destination: (req:Request, file: Express.Multer.File, cb:DestinationCallback) => {
        cb(null, config.uploadPath);
    },
    filename: (req:Request, file: Express.Multer.File, cb:FileNameCallback) => {
        cb(null, nanoid() + path.extname(file.originalname));
    }
})

const upload = multer({ storage })


router.get('/', async (req : Request, res : Response):Promise<object> => {
const users = await dataSource
.getRepository(User)
    .createQueryBuilder("user")
    .getMany()
return res.send({users})
})


router.post('/', upload.single("avatar"), async (req : Request, res : Response):Promise<object> => {
    console.log(req.body)
    const {name,surname,password,email, role} = req.body;
    console.log(req.body)
    const displayName = surname+' '+name[0]+'.'
    const user = new User();
    user.name = name;
    user.surname = surname;
    user.password = password;
    user.displayName= displayName;
    user.email = email;
    user.role = role;
    user.generateToken()
    console.log("user " + user)
    await user.save();
    console.log("saved")
    const userToFront:User|null = await dataSource.manager.findOneBy(User, {
        email: user.email
    })
    console.log("userToFront " + userToFront)
    return res.send({userToFront})
})


router.post('/sessions/', async (req : Request, res : Response):Promise<object> => {
    const {email, password} = req.body;
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.email = :email", { email: email })
    .addSelect('password')
    .getOne()
    if(!user) return res.status(404).send({Message:'user not found'})
    const isMatch:boolean = await user.checkPassword(password);
    if (!isMatch) return res.status(400).send({
        error: "Wrong Password"
    })
 
    const userToFront:User|null = await dataSource.manager.findOneBy(User, {
        email: req.body.email
    })
    return res.send({
                message: "message: 'Correct user  & password",
                user: userToFront
            })
})


router.delete('/sessions', async(req: Request, res: Response):Promise<void | object> => {
    const token = req.get('Authorization');
    const successMsg = {message:'success'};
    if(!token) return res.send(successMsg)
    const user = await dataSource.manager.findOneBy(User, {
        token: token
    })
    if(!user) return res.send({successMsg});
    user.token = nanoid();
    await user.save();
   
})



export default router;


