import {
    Column,
    Entity,
    PrimaryGeneratedColumn,
    CreateDateColumn,
    BaseEntity,
    ManyToOne,
    ManyToMany,
    JoinTable
  } from 'typeorm';
  import {User} from './User';
  import {Project} from './Project';

  type taskFinishType = "opened" | "done" |"failed";
  type priorityType = "A" | "B" |"C";

  interface ITask{
    id: string;
    title: string;
    description: string;
    createdAt: Date;
    dateTimeStart:Date| null;
    dateTimeDue:Date| null;
    accomplish: taskFinishType;
    priority: priorityType | null;
    author: User;
    project:Project|null;
    executors:User[];
  }

  @Entity({ name: 'Task' })
  export class Task extends BaseEntity implements ITask{
    @PrimaryGeneratedColumn('uuid')
    id!: string
    @Column({ name: 'title', type: 'varchar', length:50,nullable: false })
    title!: string
    @Column({ name: 'description', type: 'varchar', length:50,nullable: true })
    description!: string
    @CreateDateColumn({ name: 'created_at', type: Date, default: new Date() })
    createdAt!: Date;
    @Column({ name: 'dateTimeStart', type: Date,nullable: true })
    dateTimeStart!: Date | null;
    @Column({ name: 'dateTimeDue', type: Date,nullable: true })
    dateTimeDue!: Date | null;

    @Column({
        type: "enum",
        enum: ["opened", "done" , "failed"],
        default: "opened"
      })
      accomplish!: taskFinishType

     
    @Column({
      type: "enum",
      enum: ["A", "B" , "C"],
      default: "C",
      nullable: true
    })
    priority!: priorityType | null;

    

    @ManyToOne(() => User, (user: { tasks: Task[]; }) => user.tasks,{eager : true})
      author!: User;

    @ManyToMany(() => User,{eager : true, cascade: true, onUpdate:'CASCADE',onDelete: 'CASCADE'})
    @JoinTable()
    executors!: User[];
    
    @ManyToOne(()=>Project,(project:{tasks: Task[]}) => project.tasks)
    project!: Project | null;
  }
