import { myDataSource } from "./app-data-source";
import { User, UserRole } from "./models/User";

import { faker } from '@faker-js/faker';
import { Task } from "./models/Task";
import { Project } from "./models/Project";

function randomIntFromInterval(min:number, max:number) { 
  return Math.floor(Math.random() * (max - min + 1) + min)
}

const loadFixtures = async () => {
  myDataSource
  .initialize()
  .then(async () => {
    const repositoryTask = myDataSource.getRepository(Task);
    await repositoryTask.delete({});
    const repositoryProject = myDataSource.getRepository(Project);
    await repositoryProject.delete({})
    const repositoryUser = myDataSource.getRepository(User);
    await repositoryUser.delete({});
    console.log('========================== ' + '\n' + 'Data Source has been cleared!' +'\n' + '==========================')
    
    const userRoles = [{role: UserRole.DIRECTOR}, {role: UserRole.SUPERUSER}, {role: UserRole.USER}, {role: UserRole.USER}];
    const users = []
    for (let i = 0; i < 4; i++) {
      const name = faker.name.firstName()
      const surname = faker.name.lastName()
      const displayName = name + ' ' + surname[0] + '.'
      const user = new User()
      user.name = name;
      user.surname = surname;
      user.password = '12345qwert';
      user.displayName= displayName;
      user.phone = faker.phone.number('+77#########')
      user.email = faker.internet.email();
      user.role = userRoles[i].role;
      user.generateToken()
      await user.save();
      users.push(user)
    }
    const tasks:Task[] = []
    type taskFinishType = "opened" | "done" |"failed";
    type priorityType = "A" | "B" |"C";
    const priorities:priorityType[] = ["A", "B" , "C"]
    const accomplish:taskFinishType[] = ["opened", "done" , "failed"]
    for (let i = 0; i < 20; i++) {
      if (i <= 15) {
        const newTask = new Task();
        newTask.title = `Buy ${faker.commerce.productName()}`;
        newTask.description = faker.random.words(4);
        newTask.executors = faker.helpers.arrayElements(users, randomIntFromInterval(0, 3));
        newTask.dateTimeDue = faker.date.soon(randomIntFromInterval(1, 15));
        newTask.dateTimeStart = faker.date.recent((randomIntFromInterval(0, 8)));
        newTask.author = faker.helpers.arrayElement(users);
        newTask.accomplish = faker.helpers.arrayElement(accomplish);
        newTask.priority = faker.helpers.arrayElement(priorities);
        await newTask.save();
        tasks.push(newTask)
      }  else {
        const newTask = new Task();
        newTask.title = `Buy ${faker.commerce.productName()}`;
        newTask.description = faker.random.words(4);
        newTask.executors = faker.helpers.arrayElements(users, randomIntFromInterval(0, 3));
        newTask.dateTimeDue = null;
        newTask.dateTimeStart = null;
        newTask.author = faker.helpers.arrayElement(users);
        newTask.accomplish = accomplish[0];
        newTask.priority = faker.helpers.arrayElement(priorities);
        await newTask.save();
        tasks.push(newTask)
      }
    }
    for (let i = 0; i < 5; i++) {
        const newProject = new Project();
        newProject.title = `Project ${faker.random.words(1)}`;
        newProject.color = faker.random.words(4);
        newProject.admin = faker.helpers.arrayElement(users);
        newProject.workers = faker.helpers.arrayElements(users, randomIntFromInterval(1, 3));
        newProject.tasks = faker.helpers.arrayElements(tasks, randomIntFromInterval(0, 19));
        await newProject.save();
    }
    console.log('========================== ' + '\n' + 'Fixtures done!' +'\n' + '==========================')
  
  })
    
    

  .catch((err) => {
      console.error("Error during Data Source initialization:", err)
  })
};

loadFixtures()