import { 
  ADD_NEW_TASK_FAILURE, 
  ADD_NEW_TASK_REQUEST, 
  ADD_NEW_TASK_SUCCESS, 
  EDIT_TASK_FAILURE, 
  EDIT_TASK_REQUEST, 
  EDIT_TASK_SUCCESS, 
  FETCH_CALENDAR_TASKS_FAILURE, 
  FETCH_CALENDAR_TASKS_REQUEST, 
  FETCH_CALENDAR_TASKS_SUCCESS,
  DELETE_TASK_SUCCESS,
  DELETE_TASK_REQUEST,
  DELETE_TASK_FAILURE,
  FETCH_ALL_TASKS_SUCCESS} from "../actionTypes/tasksTypes";

const initialState = {
    calendarTasks: [],
    loading: false,
    error: null,
};

const tasksReduсer = (state = initialState, action) => {
  switch(action.type) {
    case FETCH_CALENDAR_TASKS_REQUEST:
        return {...state, loading: true};
    case FETCH_CALENDAR_TASKS_SUCCESS:
        const newArr = []
          action.tasks.forEach((task)=>{
            if (task.dateTimeStart && task.dateTimeDue) {
              if (new Date(task.dateTimeDue).getTime() - new Date(task.dateTimeStart).getTime() < (10 * 3600000)) {
              const dateStart = task.dateTimeStart.split('T')[0]
              const timeStart = task.dateTimeStart.split('T')[1]
              const timeEnd = task.dateTimeDue.split('T')[1]
              const dayStart = parseInt(dateStart.split('-')[2])
              const monthStartNumber =  parseInt(dateStart.split('-')[1])
              const yearStartNumber =  parseInt(dateStart.split('-')[0])
              const timeStartHour = parseInt(timeStart.split(':')[0])
              const timeEndHour = parseInt(timeEnd.split(':')[0])
              const timeStartMinute = parseInt(timeStart.split(':')[1])
              const timeEndMinute = parseInt(timeEnd.split(':')[1])
              newArr.push({...task, infoForCell: { 
                startDay: dayStart, 
                startHour: timeStartHour, 
                startMonth: monthStartNumber,
                startYear: yearStartNumber,
                startMinute: timeStartMinute,
                endHour: timeEndHour,
                endMinute: timeEndMinute,
                }
              } )
              }
            }
          })
        return {...state, loading: false, calendarTasks: newArr};
    case FETCH_ALL_TASKS_SUCCESS:
        return {...state, loading: false, tasks: action.tasks}; 
    case FETCH_CALENDAR_TASKS_FAILURE:
        return {...state, loading: false, error: action.error};
    case ADD_NEW_TASK_SUCCESS:
      return {...state, loading: false};
    case ADD_NEW_TASK_REQUEST:
      return {...state, loading: true};
    case ADD_NEW_TASK_FAILURE:
      return {...state, loading: false, error: action.error};
    case EDIT_TASK_SUCCESS:
      return {...state, loading: false};
    case EDIT_TASK_REQUEST:
      return {...state, loading: true};
    case EDIT_TASK_FAILURE:
      return {...state, loading: false, error: action.error};
    case DELETE_TASK_SUCCESS:
      return {...state, loading: false};
    case DELETE_TASK_REQUEST:
      return {...state, loading: true};
    case DELETE_TASK_FAILURE:
      return {...state, loading: false, error: action.error};
    default: 
        return state;
}
};

export default tasksReduсer;