import { 
  ADD_NEW_TASK_FAILURE, 
  ADD_NEW_TASK_REQUEST, 
  ADD_NEW_TASK_SUCCESS, 
  DELETE_TASK_FAILURE, 
  DELETE_TASK_REQUEST, 
  DELETE_TASK_SUCCESS, 
  EDIT_TASK_FAILURE, 
  EDIT_TASK_REQUEST, 
  EDIT_TASK_SUCCESS, 
  FETCH_CALENDAR_TASKS_FAILURE, 
  FETCH_CALENDAR_TASKS_REQUEST, 
  FETCH_CALENDAR_TASKS_SUCCESS,
  FETCH_ALL_TASKS_SUCCESS} from "../actionTypes/tasksTypes";
import axios from '../../axiosPlanner'

const fetchCalendarTasksRequest = () => {
  return {type: FETCH_CALENDAR_TASKS_REQUEST}
};

const fetchCalendarTasksSuccess = (tasks) => {
  return {type: FETCH_CALENDAR_TASKS_SUCCESS, tasks}
};

const fetchAllTasksSuccess = (tasks) => {
  return {type: FETCH_ALL_TASKS_SUCCESS, tasks}
};


const fetchCalendarTasksFailure = (error) => {
  return {type: FETCH_CALENDAR_TASKS_FAILURE, error}
};

export const fetchCalendarTasks = () => {
  return async (dispatch) => {
      dispatch(fetchCalendarTasksRequest());
      try {
        const response = await axios.get("/tasks");
        dispatch(fetchCalendarTasksSuccess(response.data.tasks))
      } catch (error) {
        dispatch(fetchCalendarTasksFailure(error.response.data));
      }
  }
};
export const fetchAllTasks = () => {
  return async (dispatch) => {
      dispatch(fetchCalendarTasksRequest());
      try {
        const response = await axios.get("/tasks");
           dispatch(fetchAllTasksSuccess(response.data.tasks))
      } catch (error) {
        dispatch(fetchCalendarTasksFailure(error.response.data));
      }
  }
};
const addTaskRequest = () => {
  return {type: ADD_NEW_TASK_REQUEST}
};

const addTaskSuccess = () => {
  return {type: ADD_NEW_TASK_SUCCESS}
};

const addTaskFailure = (error) => {
  return {type: ADD_NEW_TASK_FAILURE, error}
};

export const addTask = (task) => {
  return async (dispatch, getState) => {
      dispatch(addTaskRequest());
      const token = getState().users?.user?.token;
      try {
        await axios.post("/tasks", task);
        dispatch(addTaskSuccess())
        dispatch(fetchCalendarTasks())
      } catch (error) {
        dispatch(addTaskFailure(error.response.data));
      }
  }
}

const editTaskRequest = () => {
  return {type: EDIT_TASK_REQUEST}
};

const editTaskSuccess = () => {
  return {type: EDIT_TASK_SUCCESS}
};

const editTaskFailure = (error) => {
  return {type: EDIT_TASK_FAILURE, error}
};

export const editTask = (task) => {
  return async (dispatch, getState) => {
      dispatch(editTaskRequest());
      // const token = getState().users?.user?.token;
      try {
        console.log('task' , task)
        const r=await axios.put("/tasks/", task);
        console.log(r)
        dispatch(editTaskSuccess())
        dispatch(fetchAllTasks())
        dispatch(fetchCalendarTasks())
      } catch (error) {
        dispatch(editTaskFailure(error.response.data));
      }
  }
}

const deleteTaskRequest = () => {
  return {type: DELETE_TASK_REQUEST}
};
 
const deleteTaskSuccess = () => {
  return {type: DELETE_TASK_SUCCESS}
};

const deleteTaskFailure = (error) => {
  return {type: DELETE_TASK_FAILURE, error}
};

export const deleteTask = (taskId) => {
  return async (dispatch, getState) => {
      dispatch(deleteTaskRequest());
      // const token = getState().users?.user?.token;
      try {
        await axios.delete(`/tasks/${taskId}`);
        dispatch(deleteTaskSuccess())
        dispatch(fetchCalendarTasks())
        dispatch(fetchAllTasks())
      } catch (error) {
        dispatch(deleteTaskFailure(error.response.data));
      }
  }
}