import * as React from "react";
import {
  Box,
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TablePagination,
  TableRow,
  Paper,
  IconButton,
  Tooltip,
  Input,
} from "@mui/material";
import { useState, useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { Done, Edit, NavigateNextOutlined } from "@mui/icons-material";
import DeleteIcon from "@mui/icons-material/Delete";
import TaskModal from "../../components/MyTasksCompoments/TaskModal/TaskModal";
import EnhancedTableHead from "./MyTasksHeader/MyTasksHeader";
import moment from "moment";
import MyTaskToolBar from "../../components/MyTasksCompoments/MyTaskToolBar";
import CustomTableCell from "../../components/MyTasksCompoments/CustomTableCell";
import MaterialUIPickers from "../../components/MyTasksCompoments/DateTimePicker/DateTimePicker";
import BasicSelect from "../../components/UI/Select/Select";
import { fetchAllTasks, deleteTask,editTask,addTask } from "../../store/actions/tasksActions";
import NewTaskForm from "../../components/MyTasksCompoments/NewTaskForm";


function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
    return 1;
  }
  return 0;
}

function getComparator(order, orderBy) {
  return order === "desc"
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}

function stableSort(array, comparator) {
  const stabilizedThis = array?.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) {
      return order;
    }
    return a[1] - b[1];
  });
  return stabilizedThis.map((el) => el[0]);
}

export default function EnhancedTable() {
  const dispatch = useDispatch();

  useEffect(() => {
    dispatch(fetchAllTasks());
  }, [dispatch]);

  const tasks = useSelector((state) => state.tasks.tasks);
console.log(tasks)
  const [recievedTasks, setRecievedTasks] = useState([]);
  const projects=[
    "project1",
    "project2",
    "project3"
  ]

  const [order, setOrder] = React.useState("asc");
  const [orderBy, setOrderBy] = React.useState("id");
  const [page, setPage] = React.useState(0);
  const [rowsPerPage, setRowsPerPage] = React.useState(5);

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  const handleChangePage = (event, newPage) => {
    setPage(newPage);
  };

  const handleChangeRowsPerPage = (event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  };

  useEffect(() => {
    if (tasks && tasks?.length > 0) {
      let currentTasks = [];
      currentTasks = tasks?.map((task) => {
        return {
          ...task,
          isEditMode: false,
          readOnly: true,
          authorDisplayName: task.author.displayName,
        };
      });
      setRecievedTasks(currentTasks);
    }
  }, [tasks]);

  const onChange = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return { ...task, [name]: value };
      }
      return task;
    });

    setRecievedTasks(newTasks);
  };

  const onAuthorChange = (e, task) => {
    const value = e.target.value;
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        const updated = { ...task };
        updated.author.displayName = value;
        updated.authorDisplayName = value;
        return updated;
      }
      return task;
    });

    setRecievedTasks(newTasks);
  };

  const onDateChange = (id, value, property) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          [property]: moment.parseZone(value, "DD/MM/YYYY", true).format(),
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onToggleEditMode = (id) => {
    console.log(id)
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          isEditMode: true,
          readOnly: false,
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onToggleEditModeDone = (id) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          isEditMode: false,
          readOnly: true,
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const HandleEditTask= (task)=>{
     dispatch(editTask(task))
  }

  const addTask = () => {
    // let newTasks=[...tasks]
    tasks.unshift({
      title: "",
      description: "",
      priority: "",
      author: "",
      executor: "",
      dateTimeStart: "",
      dateTimeDue: "",
      id: 4,
      createdAt: "",
      accomplish: " ",
    });

    // tasks=newTasks;
  };

  const deleteHandle = (id) => {
    dispatch(deleteTask(id));
  };

  const [modal, setModal] = useState({
    open: false,
    task: null,
  });

  const onModalOpen = (event, task) => {
    event.stopPropagation();
    setModal({ ...modal, open: true, id: task.id });
  };

  const handleClose = () => {
    setModal({ ...modal, open: false, id: null });
  };
  // ++++++++фильтрация по проектам+++++++++++++++

  const [projectName, setProjectName] = React.useState([]);
  const [filter, setFilter] = React.useState(false);
  const onClose=(projectName)=>{
    console.log(projectName)
    setFilter(true)
  }
  useEffect(() => {
    if (tasks && tasks?.length > 0) {
      let currentTasks = [];
      let i
      for (i=0; i<projectName?.lenght; i++)
      {currentTasks = tasks?.map((task) => {
        if (task.project=projectName)
        return {
          ...task,
            };
      })};
      setRecievedTasks(currentTasks);
    }
  }, [filter==true]);

 // ++++++++фильтрация по проектам+++++++++++++++
 
  if (
    tasks &&
    tasks?.length > 0 &&
    recievedTasks &&
    recievedTasks?.length > 0
  ) {
    return (
      <Box sx={{ width: "fullwidth" }}>
        <Paper sx={{ width: "100%", mb: 2 }}>
          <MyTaskToolBar
            onClick={() => {
              addTask();
            }}
            projects={projects}
            onClose={onClose}
           projectName={projectName}
            setProjectName={setProjectName}
          />

          <TableContainer>
            <Table sx={{ minWidth: 600 }} aria-labelledby="tableTitle">
              <EnhancedTableHead
                order={order}
                orderBy={orderBy}
                onRequestSort={handleRequestSort}
                rowCount={tasks.length}
              />
              <TableBody>
                {/* <TableRow sx={{height:'1px',margin:0,padding:0}}>
                  <TableCell align="left">
                    <Input sx={{height:'1px',margin:0,padding:0}} value={''} name="order" />
                  </TableCell>

                  <TableCell align="left">
                    <Input sx={{height:'1px',margin:0,padding:0}} value={''} name="orderBy" />
                  </TableCell>
                </TableRow> */}

                 {/* <NewTaskForm
                 onChange={onChange}
                 onModalOpen={onModalOpen}
                 onAuthorChange={onAuthorChange}
                 onDateChange={onDateChange}
                 onToggleEditMode={onToggleEditMode}
                 onToggleEditModeDone={onToggleEditModeDone}
                 HandleEditTask={HandleEditTask}
                 deleteHandle={deleteHandle}
                 /> */}

                {stableSort(recievedTasks, getComparator(order, orderBy))
                  .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                  .map((task, index) => {
                    return (

                      <TableRow hover key={task.id}>
                        <TableCell
                          component="th"
                          scope="row"
                          padding="none"
                        ></TableCell>
                        <CustomTableCell
                          {...{
                            task,
                            name: "priority",
                            value: task.priority,
                            onChange,
                          }}
                        />
                        <CustomTableCell
                          {...{
                            task,
                            name: "createdAt",
                            value: task.createdAt,
                          }}
                        />

                        <CustomTableCell
                          {...{
                            task,
                            name: "title",
                            value: task.title,
                            onChange,
                            onModalOpen,
                          }}
                        />
                       
                         {task.isEditMode ? (
                          <BasicSelect
                            items={["project1", "project2", "project3"]}
                            task={task}
                            onChange={onChange}
                          />
                        ) : (
                          <CustomTableCell
                          {...{
                            task,
                            name: "project",
                            value: task.project?.title,
                            onChange: onChange,
                          }}
                        />
                        )}
                        <CustomTableCell
                          {...{
                            task,
                            name: "author",
                            value: task.author.displayName,
                            onChange: onAuthorChange,
                          }}
                        />

                        <TableCell>
                          <MaterialUIPickers
                            task={task}
                            name="dateTimeStart"
                            onChange={onDateChange}
                          />
                        </TableCell>

                        <TableCell>
                          <MaterialUIPickers
                            task={task}
                            name="dateTimeDue"
                            onChange={onDateChange}
                          />
                        </TableCell>

                        {task.isEditMode ? (
                          <BasicSelect
                            items={["opened", "done", "failed"]}
                            task={task}
                            onChange={onChange}
                          />
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "accomplish",
                              value: task.accomplish,
                            }}
                          />
                        )}

                        <TableCell>
                          {task.isEditMode ? (
                            <IconButton
                              aria-label="done"
                              onClick={() => {onToggleEditModeDone(task.id); HandleEditTask(task) }}
                            >
                              <Done />
                            </IconButton>
                          ) : (
                            <IconButton
                              aria-label="edit"
                              onClick={() => onToggleEditMode(task.id)}
                            >
                              <Edit />
                            </IconButton>
                          )}
                        </TableCell>
                        <TableCell>
                          <Tooltip title="Delete">
                            <IconButton
                              onClick={(id) => {
                                deleteHandle(task.id);
                              }}
                            >
                              <DeleteIcon />
                            </IconButton>
                          </Tooltip>
                        </TableCell>
                      </TableRow>
                    );
                  })}
              </TableBody>
            </Table>
          </TableContainer>
          <TablePagination
            rowsPerPageOptions={[5, 10, 25]}
            component="div"
            count={tasks.length}
            rowsPerPage={rowsPerPage}
            page={page}
            onPageChange={handleChangePage}
            onRowsPerPageChange={handleChangeRowsPerPage}
          />
        </Paper>
        <TaskModal
          task={recievedTasks.find((task) => task.id === modal.id)}
          open={modal.open}
          handleClose={handleClose}
          onChange={onChange}
        />
      </Box>
    );
  }
}
