import * as React from 'react';
import { useTheme } from '@mui/material/styles';
import OutlinedInput from '@mui/material/OutlinedInput';
import InputLabel from '@mui/material/InputLabel';
import MenuItem from '@mui/material/MenuItem';
import FormControl from '@mui/material/FormControl';
import Select from '@mui/material/Select';

const ITEM_HEIGHT = 48;
const ITEM_PADDING_TOP = 8;
const MenuProps = {
  PaperProps: {
    style: {
      maxHeight: ITEM_HEIGHT * 4.5 + ITEM_PADDING_TOP,
      width: 200,
      color:'#1976d2',
      borderColor:'white'
    },
  },
};

function getStyles(name, personName, theme) {
  return {
    fontWeight:
      personName.indexOf(name) === -1
        ? theme.typography.fontWeightRegular
        : theme.typography.fontWeightMedium,
  };
}

export default function MultipleSelect(props) {

  const theme = useTheme();
 

  const handleChange = (event) => {
    const {
      target: { value },
    } = event;
    props.setProjectName(
      // On autofill we get a stringified value.
      typeof value === 'string' ? value.split(',') : value,
    );
  };

  return (
    <div>
      <FormControl sx={{ m: 1, width: 250,borderColor:'white' }}>
        <InputLabel id="demo-multiple-name-label" sx={{color:'white' }}>Project</InputLabel>
        <Select
          labelId="demo-multiple-name-label"
          id="demo-multiple-name"
          multiple
          value={props.projectName}
          onChange={handleChange}
          input={<OutlinedInput label="Name" />}
          MenuProps={MenuProps}
          sx={{color:'white' }}
          onClose={(e)=>{props.onClose(props.projectName)}}
        >
          {props.projects.map((project) => (
            <MenuItem
              key={project}
              value={project}
              style={getStyles(project, props.projectName, theme)}
            >
              {project}
            </MenuItem>
          ))}
        </Select>
      </FormControl>
    </div>
  );
}