import * as React from "react";
import {
  Box,
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TableRow,
  Paper,
  IconButton,
  Tooltip,
  Input,
} from "@mui/material";
import { useState, useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { Done, Edit, NavigateNextOutlined } from "@mui/icons-material";
import DeleteIcon from "@mui/icons-material/Delete";
import TaskModal from "../../components/MyTasksCompoments/TaskModal/TaskModal";
import moment from "moment";
import CustomTableCell from "../../components/MyTasksCompoments/CustomTableCell";
import MaterialUIPickers from "../../components/MyTasksCompoments/DateTimePicker/DateTimePicker";
import BasicSelect from "../../components/UI/Select/Select";
import { fetchAllTasks, deleteTask,editTask,addTask } from "../../store/actions/tasksActions";


export default function NewTaskForm (props) {

   
    //   const onToggleEditModeDone = (id) => {
    //     const newTasks = recievedTasks.map((task) => {
    //       if (task.id === id) {
    //         return {
    //           ...task,
    //           isEditMode: false,
    //           readOnly: true,
    //         };
    //       }
    //       return task;
    //     });
    //     setRecievedTasks(newTasks);
    //   };
   
    
    const task={
      id:0,
      title: "",
      description: "",
      createdAt: "",
      dateTimeStart: null,
      dateTimeDue: null,
      accomplish: "",
      priority: "",
      author: {
         name: "",
         },
      executors: [
        { name: "" }
      ],
      isEditMode:false,
      readOnly: true
    };

    const onToggleEditMode = (id) => {
        console.log(task)
            return {
              ...task,
              isEditMode: true,
              readOnly: false,
              
            };
        
          
      };
      console.log(task)

    return (
        <TableRow hover key={task.id}>
        <TableCell
          component="th"
          scope="row"
          padding="none"
        ></TableCell>
        <CustomTableCell
          {...{
            task,
            name: "priority",
            value: task.priority,
            onChange:props.onChange,
          }}
        />
        <CustomTableCell
          {...{
            task,
            name: "createdAt",
            value: task.createdAt,
          }}
        />

        <CustomTableCell
          {...{
            task,
            name: "title",
            value: task.title,
            onChange:props.onChange,
            onModalOpen:props.onModalOpen,
          }}
        />
       
         {task.isEditMode ? (
          <BasicSelect
            items={["project1", "project2", "project3"]}
            task={task}
            onChange={props.onChange}
          />
        ) : (
          <CustomTableCell
          {...{
            task,
            name: "project",
            value: task.project?.title,
            onChange: props.onChange,
          }}
        />
        )}
        <CustomTableCell
          {...{
            task,
            name: "author",
            value: task.author.displayName,
            onChange: props.onAuthorChange,
          }}
        />

        <TableCell>
          <MaterialUIPickers
            task={task}
            name="dateTimeStart"
            onChange={props.onDateChange}
          />
        </TableCell>

        <TableCell>
          <MaterialUIPickers
            task={task}
            name="dateTimeDue"
            onChange={props.onDateChange}
          />
        </TableCell>

        {task.isEditMode ? (
          <BasicSelect
            items={["opened", "done", "failed"]}
            task={task}
            onChange={props.onChange}
          />
        ) : (
          <CustomTableCell
            {...{
              task,
              name: "accomplish",
              value: task.accomplish,
            }}
          />
        )}

        <TableCell>
          {task.isEditMode ? (
            <IconButton
              aria-label="done"
              onClick={() => {props.onToggleEditModeDone(task.id); props.HandleEditTask(task) }}
            >
              <Done />
            </IconButton>
          ) : (
            <IconButton
              aria-label="edit"
              onClick={() => onToggleEditMode(task.id)}
            >
              <Edit />
            </IconButton>
          )}
        </TableCell>
        <TableCell>
          <Tooltip title="Delete">
            <IconButton
              onClick={(id) => {
                props.deleteHandle(task.id);
              }}
            >
              <DeleteIcon />
            </IconButton>
          </Tooltip>
        </TableCell>
      </TableRow>
    );
  
}
