import * as React from 'react';
import AppBar from '@mui/material/AppBar';
import Box from '@mui/material/Box';
import Toolbar from '@mui/material/Toolbar';
import Typography from '@mui/material/Typography';
import Button from '@mui/material/Button';
import MultipleSelect from '../../components/UI/MultipleSelect/MultipleSelect';

export default function MyTaskToolBar(props) {
  
  return (
    <Box sx={{ flexGrow: 1 }}>
      <AppBar position="static">
        <Toolbar>
         <Typography variant="h6" component="div" sx={{ flexGrow: 1 }}>
            Мои задачи
          </Typography>
          <MultipleSelect
          projects={props.projects}
          onClose={props.onClose}
          projectName={props.projectName}
          setProjectName={props.setProjectName}
          />
          <Button color="inherit" onClick={props.onClick} >Добавить задачу</Button>
        </Toolbar>
      </AppBar>
    </Box>
  );
}
