import { FormControlLabel, Switch} from "@mui/material";
import { memo, useEffect, useState } from "react";
import CalendarRow from "./CalendarRow/CalendarRow";
import CalendarSmallCell from "./CalendarSmallCell/CalendarSmallCell";
import CalendarStandartCell from "./CalendarStandartCell.js/CalendarStandartCell";
import CalendarTask from "./CalendarTask/CalendarTask";
import ModalTask from "../UI/ModalTask/ModalTask";
import MonthCalendarModalContent from "../MonthCalendarModalContent/MonthCalendarModalContent";

function MonthCalendarBody({month, year, tasks, createTaskInCellHandler, currentTask, setCurrentTask, hourFormat, setHourFormat, onChangeCurrentTaskHandler, sendNewTaskHandler, deleteTaskHandler, cellSizes, hoursInDay, daysInMonth}) {

  const [modal, setModal] = useState({open:false, y: 0, x: 0,});
  const handleOpen = (e) => {
    setModal( {
      open: true, 
      yPage: e.pageY, 
      xPage: e.pageX, 
      yDivClick: e.nativeEvent.offsetY,
      xDivClick: e.nativeEvent.offsetX,
      yDiv: e.target.offsetHeight,
      xDiv: e.target.offsetWidth,
    })
  };
  const handleClose = () => {
    setModal({...modal, open: false})
    setCurrentTask({})
  };



  return (
    <>
    <CalendarRow
            >
        <CalendarSmallCell xs={1.2}> 
         <FormControlLabel
            control={<Switch color="primary" checked={hourFormat} onChange={()=>{setHourFormat(()=>!hourFormat)}}/>}
            label="1 час"
            labelPlacement="end"
          />
        </CalendarSmallCell>
        {hoursInDay?.map((hours, i)=>{
          return (
            <CalendarStandartCell key={i} xs={cellSizes.standarCell}>
              {hours}
            </CalendarStandartCell>
            ) 
          })}
    </CalendarRow>
    {daysInMonth?.map((day, i)=>{
      return (
        <CalendarRow
          key={i}
          >
            <CalendarSmallCell xs={cellSizes.smallCell}>{day.dayNumber}</CalendarSmallCell>
            <CalendarSmallCell xs={cellSizes.smallCell}>{day.dayOfWeek}</CalendarSmallCell>
            {hoursInDay.map((hours, i)=>{
              return (
                <CalendarStandartCell 
                  key={i} 
                  item xs={cellSizes.standarCell}
                  createTaskInCellHandler={createTaskInCellHandler}
                  hours={hours}
                  dayNumber={day.dayNumber}
                  currentTask={currentTask}
                  handleOpen={handleOpen}
                  modal={modal.open}
                  >
                    <CalendarTask
                      setCurrentTask={setCurrentTask}
                      year={year}
                      month={month} 
                      tasks={tasks}
                      day={day}
                      hours={hours}
                      hourFormat={hourFormat}
                      handleOpen={handleOpen}
                      currentTask={currentTask}
                    />               
                </CalendarStandartCell>
                ) 
              })}
        </CalendarRow>
      )
    })}
    <ModalTask
      modal={modal}
      handleClose={()=>{handleClose()}}
    >
      <MonthCalendarModalContent
        title={currentTask.title}
        description={currentTask.description}
        priority={currentTask.priority}
        onChangeCurrentTaskHandler={(e)=>{ onChangeCurrentTaskHandler(e)}}
        sendNewTaskHandler={()=>{sendNewTaskHandler(); handleClose()}}
        deleteTaskHandler={()=>{deleteTaskHandler(currentTask.id); handleClose()}}
      />
    </ModalTask>
    </>
  );
}

export default MonthCalendarBody;