import express,{Router, Request, Response} from 'express';
import {Task} from '../models/Task';
import {myDataSource} from '../app-data-source';
import { User } from '../models/User';
const router:Router = express.Router();
const dataSource = myDataSource;


router.get('/', async(req:Request, res:Response):Promise<Response> => {
    const tasks = await dataSource
.getRepository(Task)
.find()
    return res.send({tasks})
})

router.post('/', async(req:Request, res:Response):Promise<Response>=>{
    const token = req.get('Authorization');
    const newTask = new Task();
    const {title,description,project,executors,dateTimeDue,dateTimeStart,accomplish,priority} = req.body;
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.token = :token", { token: token })
    .getOne()
    if (!user) return res.status(404).send({Message:'user not found'})
    newTask.title = title;
    newTask.description = description;
    newTask.project = project;
    newTask.executors = executors;
    newTask.dateTimeDue = dateTimeDue;
    newTask.dateTimeStart = dateTimeStart;
    newTask.author= user;
    newTask.accomplish = accomplish;
    newTask.priority = priority;
    await newTask.save();
    return res.send({newTask})
})

router.get('/userId/:userId', async (req: Request, res: Response):Promise<Response>=>{   
    const userId = req.params.userId;
    const tasks = await dataSource
    .getRepository(Task)
    .createQueryBuilder('task')
    .innerJoinAndSelect('task.executors', 'user')
    .where('user.id = :userId',   {userId :userId})
    .getMany()
    return res.send({tasks})
})

router.get('/my', async (req: Request, res: Response):Promise<Response>=>{
    const token = req.get('Authorization');
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.token = :token", { token: token })
    .getOne()
    if(!user) return res.status(404).send({Message:'user not found'})
    const tasks = await dataSource
    .getRepository(Task)
    .createQueryBuilder('task')
    .innerJoinAndSelect('task.executors', 'user')
    .where('user.id = :userId',   {userId :user.id})
    .getMany()
    return res.send({tasks})
})

router.delete('/:taskId',async (req: Request, res: Response):Promise<Response>=>{
    const taskId = req.params.taskId;
    await myDataSource
    .createQueryBuilder()
    .delete()
    .from(Task)
    .where("id = :id", { id: taskId })
    .execute()
    return res.send({message: 'Task deleted successfully'})

})

router.put('/',async(req:Request, res:Response)=> {
    const token = req.get('Authorization');

    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.token = :token", { token: token })
    .getOne()
    if (!user) return res.status(404).send({Message:'user not found'})
    const {id,title,description,project,dateTimeDue,dateTimeStart,executors,accomplish,priority} = req.body;
    const task = await dataSource
    .createQueryBuilder()
    .select("task")
    .from(Task, "task")
    .where("task.id = :id", { id })
    .getOne()

    if (!task) return res.status(404).send({Message:'task not found'})
    task.title= title
    task.description= description
    task.project= project
    task.dateTimeDue= dateTimeDue
    task.dateTimeStart= dateTimeStart
    task.author=user
    task.executors=executors
    task.accomplish= accomplish
    task.priority= priority    
    await task.save()
    res.send({message:'update task successfully'})
})


export default router;
