import { 
  ADD_NEW_TASK_FAILURE, 
  ADD_NEW_TASK_REQUEST, 
  ADD_NEW_TASK_SUCCESS, 
  DELETE_TASK_FAILURE, 
  DELETE_TASK_REQUEST, 
  DELETE_TASK_SUCCESS, 
  EDIT_TASK_FAILURE, 
  EDIT_TASK_REQUEST, 
  EDIT_TASK_SUCCESS, 
  FETCH_CALENDAR_TASKS_FAILURE, 
  FETCH_CALENDAR_TASKS_REQUEST, 
  FETCH_CALENDAR_TASKS_SUCCESS,
  FETCH_ALL_TASKS_SUCCESS,
  FETCH_TASKS_BY_PROJECT_SUCCESS,
  FETCH_TASKS_BY_PROJECT_FAILURE,
  FETCH_TASKS_BY_PROJECT_REQUEST,
  DELETE_DATETIMETASK_FAILURE,
  DELETE_DATETIMETASK_SUCCESS,
  DELETE_DATETIMETASK_REQUEST,
  FETCH_ALL_TASKS_BY_MEMBERSHIP_SUCCESS
  } from "../actionTypes/tasksTypes";
import axios from '../../axiosPlanner'

const fetchCalendarTasksRequest = () => {
  return {type: FETCH_CALENDAR_TASKS_REQUEST}
};

const fetchCalendarTasksSuccess = (tasks) => {
  return {type: FETCH_CALENDAR_TASKS_SUCCESS, tasks}
};

const fetchAllTasksSuccess = (tasks,projects) => {
  return {type: FETCH_ALL_TASKS_SUCCESS, tasks, projects}
};


const fetchCalendarTasksFailure = (error) => {
  return {type: FETCH_CALENDAR_TASKS_FAILURE, error}
};

export const fetchCalendarTasks = (userId) => {
  return async (dispatch) => {
      dispatch(fetchCalendarTasksRequest());
      try {
        const response = await axios.get(`/tasks/user/${userId}`);
        dispatch(fetchCalendarTasksSuccess(response.data.tasks))
      } catch (error) {
        dispatch(fetchCalendarTasksFailure(error.response.data));
      }
  }
};

export const fetchAllTasks = () => {
  return async (dispatch) => {
      dispatch(fetchCalendarTasksRequest());
      try {
        const response = await axios.get("/tasks/my");
           dispatch(fetchAllTasksSuccess(response.data.tasks,response.data.projects))
      } catch (error) {
        dispatch(fetchCalendarTasksFailure(error.response.data));
      }
  }
};

//**fetch tasks for table UsersTasks,  start*/
const fetchAllTasksByMembershipSuccess = (tasks, projects) => {
  return {type: FETCH_ALL_TASKS_BY_MEMBERSHIP_SUCCESS, tasks, projects}
};



export const fetchAllTasksByMembership = () => {
  return async (dispatch) => {
      dispatch(fetchCalendarTasksRequest());
      try {
        const response = await axios.get("/tasks/users-tasks");
           dispatch(fetchAllTasksByMembershipSuccess(response.data.tasks, response.data.projects))
      } catch (error) {
        dispatch(fetchCalendarTasksFailure(error.response.data)); 
      }
  }
};

//**end*/


const addTaskRequest = () => {
  return {type: ADD_NEW_TASK_REQUEST} 
};

const addTaskSuccess = () => {
  return {type: ADD_NEW_TASK_SUCCESS}
};

const addTaskFailure = (error) => {
  return {type: ADD_NEW_TASK_FAILURE, error}
};

export const addCalendarTask = (task, userId) => {
  return async (dispatch) => {
      dispatch(addTaskRequest());
      try {
        await axios.post("/tasks", task);
        dispatch(addTaskSuccess())
        dispatch(fetchCalendarTasks(userId))
      } catch (error) {
        dispatch(addTaskFailure(error.response.data));
      }
  }
}

export const addCopyCalendarTask = (task, userId) => {
  return async (dispatch) => {
      dispatch(addTaskRequest());
      try {
        await axios.post("/copy-tasks/make-copy", task);
        dispatch(addTaskSuccess())
        dispatch(fetchCalendarTasks(userId))
      } catch (error) {
        dispatch(addTaskFailure(error.response.data));
      }
  }
}

export const addTask = (task) => {
  return async (dispatch) => {
      dispatch(addTaskRequest());
      try {
        await axios.post("/tasks", task);
        dispatch(addTaskSuccess())
        dispatch(fetchAllTasks())
      } catch (error) {
        dispatch(addTaskFailure(error.response.data));
      }
  }
}

const editTaskRequest = () => {
  return {type: EDIT_TASK_REQUEST}
};

const editTaskSuccess = () => {
  return {type: EDIT_TASK_SUCCESS}
};

const editTaskFailure = (error) => {
  return {type: EDIT_TASK_FAILURE, error}
};

export const editTask = (task) => {
  return async (dispatch) => {
      dispatch(editTaskRequest());
      try {
        await axios.put("/tasks", task);
        dispatch(editTaskSuccess())
        dispatch(fetchAllTasks())
      } catch (error) {
        dispatch(editTaskFailure(error.response.data));
      }
  }
}

export const editCalendarTask = (task, taskId, userId) => {
  return async (dispatch) => {
      dispatch(editTaskRequest());
      try {
        const response = await axios.put(`/copy-tasks/change-copy/${taskId}`, task);
        console.log(response.data)
        dispatch(editTaskSuccess())
        dispatch(fetchCalendarTasks(userId))
      } catch (error) {
        dispatch(editTaskFailure(error.response.data));
      }
  }
}

const deleteTaskRequest = () => {
  return {type: DELETE_TASK_REQUEST}
};
 
const deleteTaskSuccess = () => {
  return {type: DELETE_TASK_SUCCESS}
};

const deleteTaskFailure = (error) => {
  return {type: DELETE_TASK_FAILURE, error}
};

export const deleteTask = (taskId) => {
  return async (dispatch) => {
      dispatch(deleteTaskRequest());
      try {
        await axios.delete(`/tasks/${taskId}`);
        dispatch(deleteTaskSuccess())
        dispatch(fetchAllTasks())
      } catch (error) {
        dispatch(deleteTaskFailure(error.response.data));
      }
  }
}

export const deleteCalendarTask = (taskId, userId) => {
  return async (dispatch) => {
      dispatch(deleteTaskRequest());
      try {
        await axios.delete(`/copy-tasks/${taskId}`);
        dispatch(deleteTaskSuccess())
        dispatch(fetchCalendarTasks(userId))
      } catch (error) {
        dispatch(deleteTaskFailure(error.response.data));
      }
  }
}



const fetchTasksByProjectRequest = () => {
  return {type: FETCH_TASKS_BY_PROJECT_REQUEST}
};

const fetchTasksByProjectSuccess = () => {
  return {type: FETCH_TASKS_BY_PROJECT_SUCCESS}
};

const fetchTasksByProjectFailure = (error) => {
  return {type: FETCH_TASKS_BY_PROJECT_FAILURE, error}
};

export const fetchTasksByProject = (projects) => {
  return async (dispatch) => {
      dispatch(fetchTasksByProjectRequest());
      try {
        const response =await axios.post("/tasks/project", projects);
        dispatch(fetchTasksByProjectSuccess(response.data.tasks))
      } catch (error) {
        dispatch(fetchTasksByProjectFailure(error.response.data));
      }
  }
}



const deleteDateTimeTaskRequest = () => {
  return {type: DELETE_DATETIMETASK_REQUEST}
};
 
const deleteDateTimeTaskSuccess = () => {
  return {type: DELETE_DATETIMETASK_SUCCESS}
};

const deleteDateTimeTaskFailure = (error) => {
  return {type: DELETE_DATETIMETASK_FAILURE, error}
};

export const deleteDateTimeTask = (dateTimeTaskId) => {
  return async (dispatch) => {
      dispatch(deleteDateTimeTaskRequest());
      try {
        await axios.delete(`/copy-tasks/${dateTimeTaskId}`);
        dispatch(deleteDateTimeTaskSuccess())
        dispatch(fetchAllTasks())
      } catch (error) {
        dispatch(deleteDateTimeTaskFailure(error.response.data));
      }
  }
}



/** add new task in UserTasks Table */
const addTaskToUserTasksTableRequest = () => {
  return {type: ADD_NEW_TASK_REQUEST} 
};

const addTaskToUserTasksTableSuccess = () => {
  return {type: ADD_NEW_TASK_SUCCESS}
};

const addTaskToUserTasksTableFailure = (error) => {
  return {type: ADD_NEW_TASK_FAILURE, error}
};

export const addTaskToUserTasksTable = (task) => {
  return async (dispatch) => {
      dispatch(addTaskToUserTasksTableRequest());
      try {
        await axios.post("/tasks/users", task);
        dispatch(addTaskToUserTasksTableSuccess())
        dispatch(fetchAllTasksByMembership())
      } catch (error) {
        dispatch(addTaskToUserTasksTableFailure(error.response.data));
      }
  }
}

/** end */