import {useNavigate} from "react-router-dom";
import {useDispatch, useSelector} from "react-redux";

import { useEffect } from "react";
import ProjectForm from "../../components/ProjectComponents/ProjectForm/ProjectForm";
import { createProject, fetchProjects } from "../../store/actions/projectsActions";

const NewProject = () => {
    const dispatch = useDispatch();
    const projects = useSelector(state => state.projects.projects);
    const navigate = useNavigate();

    const onSubmit = async (projectData) => {
        await dispatch(createProject(projectData, navigate));
        console.log(projectData)
    };

    useEffect(()=> {
        dispatch(fetchProjects());
    }, [dispatch])

    return (
        <>
            <ProjectForm projects={projects} onSubmit={onSubmit} />
        </>
    );
};

export default NewProject;