import { Card, CardActions, CardContent, Grid, IconButton, Tooltip } from "@mui/material";
import { Link, useParams } from "react-router-dom";
import ArrowForwardIcon from "@mui/icons-material/ArrowForward";
import { useDispatch, useSelector } from "react-redux";
import DeleteIcon from "@mui/icons-material/Delete";
import { deleteMember } from "../../../store/actions/projectsActions";

const ProjectMembersItem = ({ displayName, roleProject, id, roleProjectOfAuthor, userId, members, authorOfProject }) => {
    console.log(displayName)
    const dispatch = useDispatch();
    const user = useSelector(state => state.users)
    let params = useParams()
    console.log(members)
    console.log(userId)
    const { projects, project } = useSelector(state => state.projects);

    const deleteHandle = (userId, projectId) => {
        if (members.length > 1) {
            dispatch(deleteMember(userId, params.id))
        } else {
            alert("Нельзя удалить автора проекта")
        }
      };

    return <>
        <Grid item xs={12} sm={12} md={6} lg={4}>
            <Card>
                <CardContent>
                    <strong>
                        <br></br>
                        {displayName}
                    </strong>
                    <strong>
                        <br></br>
                        роль: {roleProject}
                    </strong>
                    <strong>

                        {(members.filter(e => e.user.displayName === authorOfProject).length > 0) ?
                            (<strong>
                                <Tooltip title="Удалить">
                                    <IconButton
                                        onClick={(id) => {
                                            deleteHandle(userId);
                                        }}
                                    > {(displayName !== authorOfProject) ? <DeleteIcon style={{ marginTop: "-5px" }} /> : null}                                       
                                    </IconButton>
                                </Tooltip>
                            </strong>) : null}
                    </strong>
                </CardContent>
            </Card>
        </Grid>
    </>
};

export default ProjectMembersItem;
