import { Box } from "@mui/material";
import { memo } from "react";

const MonthDefaultTaskStyles = {
  position: 'relative',
  height: '30px',
  backgroundColor: 'lightgreen',
  whiteSpace: 'nowrap',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
  borderRadius: '10px',
  margin: '5px 10px',
  display: 'flex',
  justifyContent: 'flex-start',
  alignItems: 'center',
  paddingLeft: '5px',
  zIndex: '5'
}
const WeekDefaultTaskStyles = {
  boxSizing: 'border-box',
  padding: '0 5px',
  borderRadius: '2px',
  border: '1px solid white',
  backgroundColor:'lightgreen',
  height: `100%`,
  width: `100%`,
  zIndex: 5,
  textAlign: 'left',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
}


const DefaultTask = ({ week }) => {

  return (<>
    <Box
      sx={week ? WeekDefaultTaskStyles : MonthDefaultTaskStyles}
    >
      <span>
        Задача
      </span>
    </Box>
  </>)
};

export default memo(DefaultTask);