import { myDataSource } from "./app-data-source";
import { User, UserRole } from "./models/User";

import { faker } from '@faker-js/faker';
import { priorityType, Task, taskFinishType } from "./models/Task";
import { Project } from "./models/Project";
import { Member, MemberRole } from "./models/Member";
import { DateTimeTask } from "./models/DateTimeTask";

function randomIntFromInterval(min:number, max:number) { 
  min = Math.ceil(min);
  max = Math.floor(max);
  return Math.floor(Math.random() * (max - min) + min);
}

let countMembers =0
let countRolesProject=0

const cycleThroughObject=(countKey:number,objectObserve:any):MemberRole=>{
  let arrayOfKeys =  Object.keys(objectObserve)
  let keyOfObject = arrayOfKeys[countKey]
  let valueOfKey = objectObserve[keyOfObject]
  countKey++
  if(countKey===arrayOfKeys.length-1){
    countKey=0
  }
  return valueOfKey
}
const cycleArrayOfMembers=(countIndex:number, members:Member[]):Member=>{
  let member = members[countIndex]
  countIndex++
  if (countIndex ===members.length-1){
    countIndex=0
  }
  return member
}


const loadFixtures = async () => {
  myDataSource
  .initialize()
  .then(async () => {
    const repositoryMember = myDataSource.getRepository(Member);
    await repositoryMember.delete({})
    const repositoryTask = myDataSource.getRepository(Task);
    await repositoryTask.delete({});
    const repositoryDateTimeTask = myDataSource.getRepository(DateTimeTask);
    await repositoryDateTimeTask.delete({})
    const repositoryProject = myDataSource.getRepository(Project);
    await repositoryProject.delete({})
    const repositoryUser = myDataSource.getRepository(User);
    await repositoryUser.delete({});
    console.log('========================== ' + '\n' + 'Data Source has been cleared!' +'\n' + '==========================')
    
    const userRoles = [{role: UserRole.SUPERUSER}, {role: UserRole.USER}, {role: UserRole.USER},{role: UserRole.USER},];
    const users = []
    for (let i = 0; i < 3; i++) {
      const name = faker.name.firstName()
      const surname = faker.name.lastName()
      const displayName = name + ' ' + surname[0] + '.'
      const user = new User()
      user.name = name;
      user.surname = surname;
      user.password = '123';
      user.displayName= displayName;
      user.phone = faker.phone.number('+77#########')
      user.email = 'a@a.a'+i;
      user.role = userRoles[i].role;
      user.generateToken()
      await user.save();
      users.push(user)
    }

    const tasks:Task[] = []
    const priorities:priorityType[] = ["A", "B" , "C"]
    const accomplish:taskFinishType[] = ["opened", "done" , "failed"]


    for (let i = 0; i < 20; i++) {
      let dateOfMonth = randomIntFromInterval(20, 30)
      let deadLineDateOfMonth = randomIntFromInterval(1, 10)
      let startDateTime = new Date(2022, 10, dateOfMonth, randomIntFromInterval(16, 21), 0, 0);
      let dueDateTime = new Date(2022, 10, dateOfMonth, randomIntFromInterval(22, 22), 0, 0);
      let deadLine = new Date(2022, 11, deadLineDateOfMonth, 0, 0, 0);
      const newDateTimeTask= new DateTimeTask()
      newDateTimeTask.dateTimeStart=startDateTime;
      newDateTimeTask.dateTimeDue=dueDateTime;
      await newDateTimeTask.save()
      if (i <= 15) {
        const newTask = new Task(); 
        newTask.title = `Buy ${faker.commerce.productName()}`;
        newTask.description = faker.random.words(4);
        newTask.author = faker.helpers.arrayElement(users);
        newTask.executor = faker.helpers.arrayElement(users);
        newTask.dateTimeTasks=[newDateTimeTask]
        newTask.dateTimeDeadLine =deadLine;
        newTask.dateTimeFactDeadLine = deadLine;
        newTask.accomplish = faker.helpers.arrayElement(accomplish);
        newTask.priority = faker.helpers.arrayElement(priorities);
        await newTask.save();
        tasks.push(newTask)
      }  else {
        const newTask = new Task();
        newTask.title = `Buy ${faker.commerce.productName()}`;
        newTask.description = faker.random.words(4);
        newTask.executor = faker.helpers.arrayElement(users);
        newTask.author = faker.helpers.arrayElement(users);
        newTask.accomplish = accomplish[0];
        newTask.priority = faker.helpers.arrayElement(priorities);
        await newTask.save();
        tasks.push(newTask)
      }
    }

    const members:Member[]=[]
    for (let i = 0; i <5; i++) {
      const newMember = new Member();
      newMember.user = faker.helpers.arrayElement(users);
      newMember.roleProject=cycleThroughObject(countRolesProject, MemberRole);
      await newMember.save();
      members.push(newMember)
    }

    const projects:Project[] = []
    for (let i = 0; i < 3; i++) {
        const newProject = new Project();
        newProject.title = `Project ${faker.random.words(1)}`;
        newProject.color = faker.random.words(1);
        newProject.members = faker.helpers.arrayElements(members, 3);
        newProject.tasks= faker.helpers.arrayElements(tasks, randomIntFromInterval(2, 19));
        await newProject.save();
        projects.push(newProject)
    }


    console.log('========================== ' + '\n' + 'Fixtures done!' +'\n' + '==========================')
  })
  
  
  
  .catch((err) => {
    console.error("Error during Data Source initialization:", err)
  })
};

loadFixtures()