import { Grid, TextField, MenuItem } from "@mui/material";
import PropTypes from "prop-types";

const FormElement = ({ name, label, state, error, onChange, select, options, type = "'text" }) => {
    let inputChildren = null

    if (select) {
        inputChildren = options?.map(option => {
            return <MenuItem key={option._id} value={option._id}>
            {option.name}
            </MenuItem>
        })
    }
    let input = <TextField
        select={select}
        id={name}
        name={name}
        label={label}
        type={type}
        variant="outlined"
        value={state?.[name]}
        onChange={onChange}
        error={!!error}
        helperText={error}
        fullWidth
    >
        {inputChildren}
    </TextField>
    return <Grid item xs={12}>
        {input}
    </Grid>
}

FormElement.propTypes = {
    name: PropTypes.string.isRequired,
    label: PropTypes.string.isRequired,
    onChange: PropTypes.func.isRequired,
    state: PropTypes.object,
    error: PropTypes.string,
    type: PropTypes.string
}

export default FormElement;