import { Modal, IconButton } from "@mui/material";
import "./TaskModal.css";
import { Done } from "@mui/icons-material";
import Input from "@mui/material/Input";

const TaskModal = (props) => {
  return (
    <Modal
      aria-labelledby="transition-modal-title"
      aria-describedby="transition-modal-description"
      className={"modal"}
      closeAfterTransition
      onClose={props.handleClose}
      open={props.open}
    >
      {props?.task?.isEditMode ? (
        <div className="modalBox">
          <Input
            value={props.task.title}
            name="title"
            onChange={(e) => props.onChange(e, props.task)}
            style={{
              width: "auto",
              fontSize: "12px",
              color: "white",
              fontWeight: "600",
            }}
          />
          <Input
            value={props.task.description}
            name="description"
            onChange={(e) => props.onChange(e, props.task)}
            style={{ width: "auto", fontSize: "12px", color: "white" }}
          />
          <IconButton aria-label="done" onClick={props.handleClose}>
            <Done />
          </IconButton>
        </div>
      ) : (
        <div className="modalBox">
          {props.task && props.task.title && (
            <div
              style={{
                width: "200px",
                height: "200px",
                color: "white",
                fontWeight: "600",
              }}
            >
              {props.task.title}
            </div>
          )}
          {props.task && props.task.description && (
            <div style={{ width: "200px", height: "200px", color: "white" }}>
              {props.task.description}
            </div>
          )}
          <IconButton
            sx={{ marginLeft: 0, color: "white" }}
            aria-label="close"
            onClick={props.handleClose}
          >
            X
          </IconButton>
        </div>
      )}
    </Modal>
  );
};

export default TaskModal;
