import { REGISTER_USER_REQUEST, REGISTER_USER_SUCCESS, REGISTER_USER_FAILURE, LOGIN_USER_SUCCESS, LOGIN_USER_FAILURE, LOGOUT_USER_SUCCESS } from "../actionTypes/actionTypes";

const initialState = {
    user: {
        name: 'Ivan',
        surname: 'Petrov',
        email: 'test@gmail.com',
        role: 'superuser'
      },
    registerError: null,
    loginError: null,
    loading: false
};

const usersReducer = (state = initialState, action) => {
    switch(action.type) {
        case REGISTER_USER_REQUEST:
            return {...state, loading: true};
        case REGISTER_USER_SUCCESS:
            return {...state, loading: false};
        case REGISTER_USER_FAILURE:
            return {...state, loading: false, registerError: action.error};
        case LOGIN_USER_SUCCESS:
            return {...state, user: action.user};    
        case LOGIN_USER_FAILURE:
            return {...state, loginError: action.error};
        case LOGOUT_USER_SUCCESS:
            return {...state, user: null};
        default: 
            return state;
    }
};

export default usersReducer;
