import { FETCH_TASKS_FAILURE, FETCH_TASKS_REQUEST, FETCH_TASKS_SUCCESS} from "../actionTypes/tasksTypes";

const initialState = {
    tasks: [],
    loading: false,
    error: null
};

const tasksReduсer = (state = initialState, action) => {
  switch(action.type) {
    case FETCH_TASKS_REQUEST:
        return {...state, loading: true};
    case FETCH_TASKS_SUCCESS:
        const newArr = []
        action.tasks.forEach((task)=>{
            if (task.dateTimeStart && task.dateTimeDue) {
              if (new Date(task.dateTimeDue).getTime() - new Date(task.dateTimeStart).getTime() < (4 * 3600000)) {
              const dateStart = task.dateTimeStart.split('T')[0]
              const timeStart = task.dateTimeStart.split('T')[1]
              const timeEnd = task.dateTimeDue.split('T')[1]
              const dayStart = parseInt(dateStart.split('-')[2])
              const monthStartNumber =  parseInt(dateStart.split('-')[1])
              const yearStartNumber =  parseInt(dateStart.split('-')[0])
              const timeStartHour = parseInt(timeStart.split(':')[0])
              const timeEndHour = parseInt(timeEnd.split(':')[0])
              const timeStartMinute = parseInt(timeStart.split(':')[1])
              const timeEndMinute = parseInt(timeEnd.split(':')[1])
              newArr.push({...task, infoForCell: { 
                startDay: dayStart, 
                startHour: timeStartHour, 
                startMonth: monthStartNumber,
                startYear: yearStartNumber,
                startMinute: timeStartMinute,
                endHour: timeEndHour,
                endMinute: timeEndMinute,
                }
              } )
              }
            }
          })
        return {...state, loading: false, tasks: newArr};
    case FETCH_TASKS_FAILURE:
        return {...state, loading: false, error: action.error};
    default: 
        return state;
}
};

export default tasksReduсer;