import * as React from "react";
import {
  Box,
  Table,
  TableBody,
  TextField,
  TableCell,
  TableContainer,
  TablePagination,
  TableRow,
  Typography,
  Paper,
  IconButton,
  Tooltip,
  Input,
} from "@mui/material";
import { useState, useEffect } from "react";
import { Done, Edit } from "@mui/icons-material";
import DeleteIcon from "@mui/icons-material/Delete";
import TaskModal from "../../components/MyTasksCompoments/TaskModal/TaskModal";
import EnhancedTableHead from "./MyTasksHeader/MyTasksHeader";
import { Container } from "@mui/system";
import { DateTimePicker, LocalizationProvider } from "@mui/x-date-pickers";
import { AdapterMoment } from "@mui/x-date-pickers/AdapterMoment";
import moment from "moment";
import MyTaskToolBar from '../../components/MyTasksCompoments/MyTaskToolBar';
import CustomTableCell from "../../components/MyTasksCompoments/CustomTableCell";
import MaterialUIPickers from "../../components/UI/DateTimePicker/DateTimePicker";

function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
    return 1;
  }
  return 0;
}

function getComparator(order, orderBy) {
  return order === 'desc'
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}


function stableSort(array, comparator) {
  const stabilizedThis = array.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) {
      return order;
    }
    return a[1] - b[1];
  });
  return stabilizedThis.map((el) => el[0]);
}


export default function EnhancedTable() {

  const [order, setOrder] = React.useState('asc');
  const [orderBy, setOrderBy] = React.useState('id');
   const [page, setPage] = React.useState(0);
   const [rowsPerPage, setRowsPerPage] = React.useState(5);
  const [newStartedDate, setNewStartedDate] = React.useState();
  const [newDueDate, setNewDueDate] = React.useState();

  const handleChange = (id, newDate) => {
    setNewStartedDate({ id: id, date: newDate });

  };

  const [tasks,setTasks]=useState([
  {
    user:"first",
    title:"задача1",
    description:"описание задачи11111",
    priority:"A",
    author:"Ivan",
    executor:"Arman",
    dateTimeStart: "2022-10-26T11:00:00",
      dateTimeDue: "2022-10-27T10:30:00",
    id:1,
    dateCreated:"26.10.2022"
  },
  {
      user:"second",
      title:"задача2",
      description:"описание задачи222222",
      author:"Ivan",
      executor:"Elena",
      priority:"B",
      dateTimeStart: "2022-10-26T13:30:00",
      dateTimeDue: "2022-10-27T12:30:00",
      id:2,
      dateCreated:"26.10.2022"
    },
    {
      user:"theird",
      title:"задача3",
      description:"описание задачи333333bjh,khkuhlhvilv hmgjtycikg mkgyxxkjfkkmgyhkfrdtseygdtjtuliuo8plfyvguh,bb",
      author:"Artem",
      executor:"Bota",
      priority:"B",
      dateTimeStart: "2022-10-30T09:30:00",
      dateTimeDue: "2022-11-02T09:30:00",
      id:3,
      dateCreated:"27.10.2022",

    }
  ])

  useEffect(() => {
    if (newStartedDate) {
      
      let updatedTasks = [...tasks].filter((t) => t.id !== newStartedDate.id);
      const currentTask = tasks.find((t) => t.id === newStartedDate.id);
      delete currentTask.dateTimeStart;
      console.log(newStartedDate.date)
      const updatedTask = {
        ...currentTask,
        dateTimeStart: moment.parseZone(newStartedDate.date, 'DD/MM/YYYY', true).format()
       
      };

      updatedTasks.push(updatedTask);

      setTasks(updatedTasks);
    }
    else if (newDueDate){
      let updatedTasks = [...tasks].filter((t) => t.id !== newDueDate.id);
      const currentTask = tasks.find((t) => t.id === newDueDate.id);
      delete currentTask.dateTimeDue;
      console.log(newDueDate.date)
      const updatedTask = {
        ...currentTask,
        dateTimeDue: moment.parseZone(newDueDate.date, 'DD/MM/YYYY', true).format()
       
      };

      updatedTasks.push(updatedTask);

      setTasks(updatedTasks);
    }
  }, [newStartedDate || newDueDate]);

  
  const onToggleEditMode = id => {
    setTasks(state => {
      return tasks.map(task => {
        if (task.id === id) {
          return { ...task, isEditMode: !task.isEditMode };
        }
        return task;
      });
    });
  };
  
  const onChange = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const { id } = task;
    const newTasks = tasks.map(task => {
      if (task.id === id) {
        return { ...task, [name]: value };
      }
      return task;
    });
    setTasks(newTasks);
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };

  
  const deleteTask=(id)=>{
    console.log(id)
    let newTasks=[...tasks]
    newTasks.splice(tasks[id],1)
    setTasks(newTasks)
  };

  const handleChangePage = (event, newPage) => {
    setPage(newPage);
  };

  const handleChangeRowsPerPage = (event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  };
  
  const [modal, setModal] =useState({
    open: false,
    task: null
  });
  const onModalOpen = (event, task) => {
    event.stopPropagation();
    setModal({ ...modal, open: true, task});
  };
  const handleClose = () => {
    setModal({ ...modal, open: false, task: null });
  };
 
  const addTask=()=>{
  let newTasks=[...tasks]
  newTasks.unshift(
    {
      user:"",
      title:"",
      description:"",
      priority:"",
      author:"",
      executor:"",
      dateTimeStart:"",
      dateTimeDue:"",
      id:4,
      dateCreated:""
    }
   )
  setTasks(newTasks)
  };

 
  return (
    <Box sx={{ width: 'fullwidth' }}>
      <Paper sx={{ width: '100%', mb: 2 }}>

      <MyTaskToolBar
       onClick={()=>{addTask()}}
      />

        <TableContainer>
       
          <Table
            sx={{ minWidth: 600 }}
            aria-labelledby="tableTitle"
          >
            <EnhancedTableHead
              order={order}
              orderBy={orderBy}
              onRequestSort={handleRequestSort}
              rowCount={tasks.length}
            />
            <TableBody>

              {stableSort(tasks, getComparator(order, orderBy))
                .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                .map((task, index) => {
                
                  return (
               
                    <TableRow
                      hover
                      key={task.id}                    
                    >
                      
                     <TableCell
                        component="th"
                        scope="row"
                        padding="none"
                      ></TableCell>  
                        <CustomTableCell {...{ task, name: "priority", onChange }} />
                        <CustomTableCell {...{ task, name: "dateCreated", onChange }} />
                        <CustomTableCell {...{ task, name: "title", onChange, onModalOpen}}  />
                        <CustomTableCell {...{ task, name: "author", onChange }} />

                        {task.isEditMode ? ( 
                        <TableCell key={task.id}>
                          <MaterialUIPickers
                          newStartedDate={newStartedDate}
                          task={task}
                          setNewStartedDate={setNewStartedDate}
                          />
                       </TableCell>)
                        : <CustomTableCell {...{ task, name: "dateTimeStart", onChange}} />
                        }
                
                        {task.isEditMode ? ( 
                          <TableCell key={task.id}>
                            <MaterialUIPickers
                            newDueDate={newDueDate}
                            task={task}
                            setNewDueDate={setNewDueDate}
                            />
                        </TableCell>)
                        : <CustomTableCell {...{ task, name: "dateTimeDue", onChange}} />
                        }
                       
                        <CustomTableCell {...{ task, name: "done", onChange }} />                      

                      <TableCell >
               
                {task.isEditMode ? (
                 
                    <IconButton
                      aria-label="done"
                      onClick={() => onToggleEditMode(task.id)}
                    >
                      <Done/>
                    </IconButton>
                     
                ) : (
                  <IconButton
                    aria-label="delete"
                    onClick={() => onToggleEditMode(task.id)}
                  >
                    <Edit/>
                  </IconButton>
                )}
              </TableCell>
                     <TableCell>
                      <Tooltip title="Delete">
                      <IconButton onClick={(id)=>{deleteTask(id)}}>
                        <DeleteIcon />
                      </IconButton>
                      </Tooltip>
                    </TableCell>
                    </TableRow>
                    
                   
                  );
                })}
           
            </TableBody>
          </Table>
        </TableContainer>
        <TablePagination
          rowsPerPageOptions={[5,10, 25]}
          component="div"
          count={tasks.length}
          rowsPerPage={rowsPerPage}
          page={page}
          onPageChange={handleChangePage}
          onRowsPerPageChange={handleChangeRowsPerPage}
        />
      </Paper>
        <TaskModal
          task={modal.task}
          open={modal.open}
          handleClose={handleClose}
          onChange={(e) => {onChange(e,modal.task)}}  
          onToggleEditMode={onToggleEditMode} 
          tasks={tasks}  
          setTasks={setTasks}      
        /> 
    </Box>
  );
}
