import { Container } from '@mui/material';
import { useEffect, useState } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import MonthCalendarBody from '../../components/MonthCalendarBody/MonthCalendarBody';
import MonthCalendarHeader from '../../components/MonthCalendarHeader/MonthCalendarHeader';
import { addTask, fetchTasks} from '../../store/actions/tasksActions';

function MonthCalendar() {
  const dispatch = useDispatch();
  const { tasks } = useSelector(state => state.tasks);

  const [hourFormat, setHourFormat] = useState(false);
  const [month, setMonth] = useState('')
  const [year, setYear] = useState('')
  const [worker, setWorker] = useState('');
  const [calendarType, setCalendarType] = useState('Месяц');
  const [currentTask, setCurrentTask] = useState({})
  
  useEffect(()=>{
    setMonth(new Date().getMonth())
    setYear(new Date().getFullYear())
    dispatch(fetchTasks())
  }, [dispatch])

  const onChangeWorkerHandler = (event) => {
    setWorker(event.target.value);
  };

  const onChangeCalendarTypeHandler = (event) => {
    setCalendarType(event.target.value);
  };

  const getCurrentMonthString = (month) => {
    return ["Январь","Февраль","Март","Апрель","Май","Июнь","Июль","Август","Сентябрь","Октябрь","Ноябрь", "Декабрь"][month];
  }

  const incrementMonth = () => {
    setMonth((prevState)=>{
      if (prevState + 1 === 12 ) { 
        setYear(prevState=>prevState+1)
        return 0 
      }
      return prevState + 1
    })
  }

  const decrementMonth = () => {
    setMonth((prevState)=>{
      if (prevState - 1 === -1) {
        setYear(prevState=>prevState-1)
        return 11
      }
      return prevState - 1 
    })
  }

  function dateToISOLikeButLocal(date) {
    const offsetMs = date.getTimezoneOffset() * 60 * 1000;
    const msLocal =  date.getTime() - offsetMs;
    const dateLocal = new Date(msLocal);
    const iso = dateLocal.toISOString();
    return iso;
  }

  const createTaskInCellHandler = (dayNumber, dayHour) => {
    const hour = parseInt(dayHour.split(':')[0])
    let hourDue
    if (hourFormat) {
      hourDue = hour + 0
    } else {
      hourDue = hour + 1
    }
    const newTask = {
      title:"Задача",
      description:"описание",
      dateTimeStart: dateToISOLikeButLocal(new Date(year, month, dayNumber, hour, 0)),
      dateTimeDue: dateToISOLikeButLocal(new Date(year, month, dayNumber, hourDue, 59)),
    }
    console.log(newTask)
    dispatch(addTask(newTask))
    setCurrentTask((newTask))
  }

  const onChangeCellTaskTitle = (e) => {
    e.stopPropagation()
    const value = e.target.value;
    const name = e.target.name;
    setCurrentTask({ ...currentTask, [name]: value })
  }

  return (
    <>
    <Container>
      <MonthCalendarHeader
        month={month}
        year={year}
        getCurrentMonthString={getCurrentMonthString} 
        decrementMonth={decrementMonth}
        incrementMonth={incrementMonth}
        onChangeCalendarTypeHandler={onChangeCalendarTypeHandler}
        onChangeWorkerHandler={onChangeWorkerHandler}
        worker={worker}
        calendarType={calendarType}
      />
      <MonthCalendarBody
        month={month}
        year={year}
        tasks={tasks}
        createTaskInCellHandler={createTaskInCellHandler}
        onChangeCellTaskTitle={onChangeCellTaskTitle}
        setCurrentTask={setCurrentTask}
        hourFormat={hourFormat} 
        setHourFormat={setHourFormat}
      />
    </Container>
    </>
  );
}

export default MonthCalendar;
