import { Modal, IconButton } from '@mui/material';
import './TaskModal.css';
import { Done } from '@mui/icons-material';
import Input from '@mui/material/Input';
import { useState, useEffect } from "react";

const TaskModal = (props) => {

  const [taskContent, setTaskContent] = useState();
  
  useEffect(() => {
    if (props.task !== null) {
      setTaskContent({
        title: props.task.title,
        description: props.task.description,
      });
    }
  }, [props.task]);
  

  const inputChangeHandler = (e) => {
    const { name, value } = e.target;
    setTaskContent((prevState) => {
      return { ...prevState, [name]: value };
    });
    props.onChange(e, props.task);
  };

  const saveModalData=()=>{
      props.handleClose()
  };
 
    return (
        <Modal
        aria-labelledby="transition-modal-title"
        aria-describedby="transition-modal-description"
        className={"modal"}
        closeAfterTransition
        onClose={props.handleClose}
        open={props.open}
      >
{ props?.task?.isEditMode ? 

        <div className="modalBox">
        <Input
               value={taskContent?.title}
               name={"title"}
               onChange={inputChangeHandler}
               style={{ width: "auto", fontSize:"12px",color: "white",fontWeight: "600" }}
                />
          <Input
                value={taskContent?.description}
                name={"description"}
                onChange={inputChangeHandler}
                style={{ width: "auto", fontSize:"12px",color: "white" }}
                />   
            <IconButton
              aria-label="done"
              onClick={saveModalData}
            >
              <Done/>
            </IconButton>        
        </div>:
        
        <div className="modalBox">
          { props.task && props.task.title && (
            <div
              style={{
                width: "200px",
                height: "200px",
                color: "white",
                fontWeight: "600"
              }}
            >
              {props.task.title}
            </div>
          )}
          {props.task && props.task.description && (
            <div style={{ width: "200px", height: "200px", color: "white" }}>
              {props.task.description}
            </div>
          )}
          <IconButton
            sx={{ marginLeft: 0, color: "white" }}
            aria-label="close"
            onClick={props.handleClose}
          >
            X
          </IconButton>
        </div>
  }
      </Modal>
    );
  };
  
export default TaskModal;