import { FormControlLabel, Switch } from "@mui/material";
import { useEffect, useState } from "react";
import CalendarRow from "./CalendarRow/CalendarRow";
import CalendarSmallCell from "./CalendarSmallCell/CalendarSmallCell";
import CalendarStandartCell from "./CalendarStandartCell.js/CalendarStandartCell";
import CalendarTask from "./CalendarTask/CalendarTask";
import ModalTask from "../UI/ModalTask/ModalTask";

function MonthCalendarBody({month, year, tasks, createTaskInCellHandler, onChangeCellTaskTitle, setCurrentTask, hourFormat, setHourFormat}) {
  
  const [hoursInDay, setHoursInDay] = useState(['8:00', '10:00', '12:00', '14:00', '16:00', '18:00', '20:00', '22:00'])
  const [daysInMonth, setDaysInMonth] = useState([])
  const [cellSizes, setCellSizes] = useState({})
  const [modal, setModal] = useState({open:false, y: 0, x: 0,});
  const handleOpen = (e) => {
    console.log(e.nativeEvent.offsetX)
    setModal( {...modal, 
      open: true, 
      yPage: e.pageY, 
      xPage: e.pageX, 
      yDivClick: e.nativeEvent.offsetY,
      xDivClick: e.nativeEvent.offsetX,
      yDiv: e.target.offsetHeight,
      xDiv: e.target.offsetWidth,
    })
  };
  const handleClose = () => setModal({...modal, open: false});


  useEffect(()=>{
    const cells = hoursInDay.length
    const xs = 10.8/cells
    setCellSizes(()=>{
      return {smallCell: 0.6, standarCell: xs}
    })
  }, [])

  useEffect(()=>{
    if (hourFormat) {
      const arr = ['8:00', '9:00', '10:00', '11:00', '12:00', '13:00', '14:00', '15:00', '16:00', '17:00', '18:00', '19:00', '20:00','21:00','22:00']
      const cells = arr.length
      const xs = 10.8/cells
      setCellSizes(()=>{
        return {smallCell: 0.6, standarCell: xs}
      })
      setHoursInDay(()=>arr)
    } else {
      const arr = ['8:00', '10:00', '12:00', '14:00', '16:00', '18:00', '20:00', '22:00']
      const cells = arr.length
      const xs = 10.8/cells
      setCellSizes(()=>{
        return {smallCell: 0.6, standarCell: xs}
      })
      setHoursInDay(()=>arr)
    }
  }, [hourFormat])

  useEffect(()=>{
    setNewMonthDays()
  }, [month])

  const getDaysInMonth = () => { 
    return new Date(year, month + 1, 0).getDate();
  }

  const getDayOfWeekString = (day) => {
    return ["ВС","ПН","ВТ","СР","ЧТ","ПТ","СБ"][day];
  }

  const getDayOfWeekNumber = (day) => {
    return new Date(year, month, day).getDay()
  }

  const setNewMonthDays = () => {
    const newDaysInMonth = []
    for (let i = 1; i <= getDaysInMonth(); i++) {
      const dayOfWeekNumber = getDayOfWeekNumber(i)
      newDaysInMonth.push({dayNumber: i, dayOfWeek: getDayOfWeekString(dayOfWeekNumber)})
    }
    setDaysInMonth(prevState=>newDaysInMonth)
  }

  return (
    <>
    <CalendarRow
            >
        <CalendarSmallCell xs={1.2}> 
         <FormControlLabel
            control={<Switch color="primary" checked={hourFormat} onChange={()=>{setHourFormat(()=>!hourFormat)}}/>}
            label="1 час"
            labelPlacement="end"
          />
        </CalendarSmallCell>
        {hoursInDay.map((hours, i)=>{
          return (
            <CalendarStandartCell key={i} xs={cellSizes.standarCell}>
              {hours}
            </CalendarStandartCell>
            ) 
          })}
    </CalendarRow>
    {daysInMonth.map((day, i)=>{
      return (
        <CalendarRow
          key={i}
          >
            <CalendarSmallCell xs={cellSizes.smallCell}>{day.dayNumber}</CalendarSmallCell>
            <CalendarSmallCell xs={cellSizes.smallCell}>{day.dayOfWeek}</CalendarSmallCell>
            {hoursInDay.map((hours, i)=>{
              return (
                <CalendarStandartCell 
                  key={i} 
                  item xs={cellSizes.standarCell}
                  onClick={()=>{createTaskInCellHandler(day.dayNumber, hours)}}
                  >
                    <CalendarTask
                      setCurrentTask={setCurrentTask}
                      onChange={(e)=>{onChangeCellTaskTitle(e)}}
                      year={year}
                      month={month} 
                      tasks={tasks}
                      day={day}
                      hours={hours}
                      hourFormat={hourFormat}
                      handleOpen={handleOpen}
                    />               
                </CalendarStandartCell>
                ) 
              })}
        </CalendarRow>
      )
    })}
    <ModalTask
      modal={modal}
      handleClose={()=>{handleClose()}}
    />
    </>
  );
}

export default MonthCalendarBody;