import {Routes, Route, Outlet, Navigate, BrowserRouter} from "react-router-dom";
import {Container} from "@mui/material";
import {useSelector} from "react-redux";
import AppToolbar from "./components/UI/AppToolBar/AppToolBar";
import MyTasks from './containers/MyTasks/MyTasks';
import Login from './containers/Login/Login';
import Register from './containers/Register/Register';
import MonthCalendar from './containers/MonthCalendar/MonthCalendar';

const ProtectedRoute = ({isAllowed, roles, redirectUrl, children}) => {
  const user = useSelector(state => state.users?.user);
  if (!isAllowed && !roles?.includes(user?.role)) {
      return <Navigate to={redirectUrl} />
  }
  return children || <Outlet />;
};

const App = () => {
    const user = useSelector(state => state.users?.user);
    return (
    <BrowserRouter>
      <Routes>
          <Route element={
            <>
              <AppToolbar/>
              <main>
                  <Container maxWidth={false} sx={{maxWidth:'2500px'}}>
                      <Outlet/>
                  </Container>
              </main>
            </>
          }>

            <Route path={"/"} element={
              <ProtectedRoute
                  isAllowed={user}
                  redirectUrl={"/sign-in"}
              >
                  <h1>week page</h1>
              </ProtectedRoute>
            }/>

            <Route path={"/week"} element={
              <ProtectedRoute
                  isAllowed={user}
                  redirectUrl={"/sign-in"}
              >
                  <h1>week page</h1>
              </ProtectedRoute>
            }/>

            <Route path={"/month"} element={
              <ProtectedRoute
                  isAllowed={user}
                  redirectUrl={"/sign-in"}
              >
                  <MonthCalendar>month page</MonthCalendar>
              </ProtectedRoute>
            }/>

            <Route path={"/my-tasks"} element={
              <ProtectedRoute
                  isAllowed={user}
                  redirectUrl={"/sign-in"}
              >
                    <MyTasks/>
              </ProtectedRoute>
            }/>

            <Route path={"/profile/:id"} element={
              <ProtectedRoute
                  isAllowed={user}
                  redirectUrl={"/sign-in"}
              >
                  <h1>profile page</h1>
              </ProtectedRoute>
            }/>

            <Route path={"/workers-tasks"} element={
              <ProtectedRoute
                  roles={["superuser"]}
                  redirectUrl={"/"}
              >
                  <h1>workers tasks page</h1>
              </ProtectedRoute>
            }/>

            <Route path={"/sign-up"} element={
              <ProtectedRoute
                  roles={["superuser"]}
                  redirectUrl={"/"}
              >
                  <Register/>
              </ProtectedRoute>
            }/>

            <Route path={"/sign-in"} element={<Login/>}/>
            <Route path='*' element={<h1>404</h1>}/>
          </Route>
      </Routes>
    </BrowserRouter>
    )
};

export default App;

