import {
    Column,
    Entity,
    PrimaryGeneratedColumn,
    CreateDateColumn,
    BaseEntity,
    ManyToOne,
    ManyToMany,
    OneToMany,
    JoinTable
  } from 'typeorm';
  import {User} from './User';
  import {Task} from './Task';

  // type IncomingData={
  //   title: string | null;
  //   color: string
  //   admin:User
  //   workers?: User[]
  //   tasks?: Task[]
  //   dateDue?:Date
  //   department?:boolean
  // }

  interface IProject{
    id: string;
    title: string;
    color: string;
    admin:User;
    workers:User[];
    tasks:Task[]|null;
    createdAt: Date;
    dateDue: Date| null;
    department:boolean;
  }

  @Entity({ name: 'Project' })
  export class Project extends BaseEntity implements IProject{
    // data: IncomingData;
    // constructor(data:IncomingData){
    //   super();
    //   this.data = data
    // }
    @PrimaryGeneratedColumn('uuid')
    id!: string

    // @Column({ name: 'title', type: 'varchar', length:100,nullable: false, default: this.data.title })
    // title!: string

    @Column({ name: 'title', type: 'varchar', length:100,nullable: false})
    title!: string

    @CreateDateColumn({ name: 'createdAt', type: Date, default: new Date() })
    createdAt!: Date;

    @Column({ name: 'color', type: 'varchar', length:100,nullable: true })
    color!: string

    @Column({ name: 'dateDue', type: Date, default: null })
    dateDue!: Date| null;

    @Column({ name: 'department', type: Boolean,nullable:true ,default: false})
    department!: boolean;

    @ManyToOne(() => User, (user: { projects: Project[]; }) => user.projects,{eager : true})
    admin!: User;
    
    @OneToMany(() => Task, (task: { project: Project; })=>task.project,{eager : true})
    tasks!:Task[]|null;
        
    @ManyToMany(() => User, (user: { projects: Project[]; }) => user.projects,{eager : true})
    @JoinTable()
    workers!: User[];
 }