import moment from "moment"

export const getDaysInMonth = (dateNow) => {
  if (dateNow.month <= 11 && dateNow.month >= 0) {
    const newDaysInMonth = []
    const daysInMonthNumber = new Date(dateNow.year, dateNow.month + 1, 0).getDate()
    for (let i = 1; i <= daysInMonthNumber; i++) {
      const dayOfWeekNumber = new Date(dateNow.year, dateNow.month, i).getDay()
      const getDayOfWeekString = ["ВС", "ПН", "ВТ", "СР", "ЧТ", "ПТ", "СБ"][dayOfWeekNumber]
      newDaysInMonth.push({ dayNumber: i, dayOfWeek: getDayOfWeekString })
    }
    return newDaysInMonth
  } else {
    return null
  }
}

export const getCurrentMonthString = (month) => {
  if (month <= 11 && month >= 0) {
    return ["Январь", "Февраль", "Март", "Апрель", "Май", "Июнь", "Июль", "Август", "Сентябрь", "Октябрь", "Ноябрь", "Декабрь"][month];
  } else {
    return null
  }
}

export const dateToISOLikeButLocal = (date) => {
  if (date instanceof Date && !isNaN(date)) {
    const offsetMs = date.getTimezoneOffset() * 60 * 1000;
    const msLocal = date.getTime() - offsetMs;
    const dateLocal = new Date(msLocal);
    const iso = dateLocal.toISOString();
    return iso;
  } else {
    return null
  }
}

export const getWeekFromCurrentDate = (year, month, curDay) => {
  const week = [0, 0, 0, 0, 0, 0, 0]
  const currentDayWeek = moment(new Date(year, month, curDay)).isoWeekday()
  for (let i = 1; i <= 7; i++) {
    if (currentDayWeek > i) {
      const day = moment(new Date(year, month, curDay - i)).date()
      const dayWeek = moment(new Date(year, month, curDay - i)).isoWeekday()
      week[dayWeek - 1] = day
    } else if (currentDayWeek === i) {
      const day = moment(new Date(year, month, curDay)).date()
      const dayWeek = moment(new Date(year, month, curDay)).isoWeekday()
      week[dayWeek - 1] = day
    } else {
      const day = moment(new Date(year, month, curDay + i - moment(new Date(year, month, curDay)).isoWeekday())).date()
      const dayWeek = i - moment(new Date(year, month, curDay)).isoWeekday() + moment(new Date(year, month, curDay)).isoWeekday()
      week[dayWeek - 1] = day
    }
  }
  return week
}

export const getWeekInfoString = (week, date) => {
  if (week[0] > week[6]) {
    if (date.currentDay < week[0]) {
      if (date.month === 0) {
        return getCurrentMonthString(11) + ' - ' + getCurrentMonthString(0) + ' ' + date.year
      }
      return getCurrentMonthString(date.month - 1) + ' - ' + getCurrentMonthString(date.month) + ' ' + date.year
    } else {
      if (date.month === 11) {
        return getCurrentMonthString(date.month) + ' - ' + getCurrentMonthString(0) + ' ' + date.year
      }
      return getCurrentMonthString(date.month) + ' - ' + getCurrentMonthString(date.month + 1) + ' ' + date.year
    }
  } else {
    return getCurrentMonthString(date.month) + ' ' + date.year
  }
}

export const getHoursInDayNumbers = (hoursInDay) => {
  return hoursInDay.map((hour) => parseInt(hour.split(':')[0]))
}

const taskIsAvailableInCell = (task, hour, hourDiffEnd, hourDiff, hourFormat) => {
  if (((task.infoForCell.endHour <= hour || task.infoForCell.startHour  <= hour) && (task.infoForCell.endHour > hour))  
  || (!hourFormat && task.infoForCell.startHour >= hour  && task.infoForCell.endHour < hour + hourDiff)
  || (!hourFormat && task.infoForCell.startHour === hour + hourDiffEnd && task.infoForCell.endHour > hour)
  || (task.infoForCell.endMinute <= 59 && task.infoForCell.endHour === hour)) {
    return true
  } else {
    return false
  }
}

const lastPlaceInLineForTask = (task, hour, hourDiffEnd, hourFormat) => {
  if ((task.infoForCell.endMinute === 59 && task.infoForCell.endHour === hour + hourDiffEnd) || (!hourFormat && task.infoForCell.endMinute === 59 && task.infoForCell.endHour === hour)) {
    return true
  } else {
    return false
  }
}


export const getLinesInDay = (availableTasks, sortedTasks, hoursInDay, hours, hourFormat) => {
  let hourDiff
  let hourDiffEnd
  const lines = []
  if (hourFormat) {
    hourDiff = 1
    hourDiffEnd = 0
  } else {
    hourDiff = 2
    hourDiffEnd = 1
  }
  
  if (availableTasks.length) {
    lines.push(hoursInDay.map((hour)=>parseInt(hour.split(':')[0])))
    for (let k = 0; k < sortedTasks.length; k++) {
      let skipLine = false
        for (let j = 0; j < lines.length; j++) {
          const line = lines[j]
          const task = sortedTasks[k]
          if (skipLine) {
            skipLine = false
            break;
          }
          for (let i = 0; i < line.length; i++) {
            const hour = hours[i]
            let havePlace = true
            if (taskIsAvailableInCell(task, hour, hourDiffEnd, hourDiff, hourFormat)) {
              if (!isNaN(line[i])) {
                for (let a = 0; a < hours.length; a++) {
                  const hour = hours[a]
                  if (lastPlaceInLineForTask(task, hour, hourDiffEnd, hourFormat)) {
                    if (isNaN(line[a])) {
                      havePlace = false
                      break;
                    }
                  }
                }
                if (!havePlace) {
                  if (j + 1 === lines.length) {
                    lines.push(hoursInDay.map((hour)=>parseInt(hour.split(':')[0])))
                  }
                  havePlace = true  
                  break;
                }
                line[i] += `-${k}`
                if (lastPlaceInLineForTask(task, hour, hourDiffEnd, hourFormat)) {
                  skipLine = true
                  break;
                }
              } else {
                  if (j + 1 === lines.length) {
                    lines.push(hoursInDay.map((hour)=>parseInt(hour.split(':')[0])))
                  }
                  break;
              }
            } 
          }
        }
    }
  }
  return lines
}

export const getSortedTasks = (availableTasks) => {
  if (availableTasks.length) {
    const newSortedArr = [...availableTasks].sort(function(a,b){
      const durattionFirstDate = a.infoForCell.endHour - a.infoForCell.startHour
      const durattionSecondDate = b.infoForCell.endHour - b.infoForCell.startHour
      return durattionSecondDate - durattionFirstDate;
    })
    return newSortedArr
  }
}

export const getAvailableTasks = (tasks, year, month, dayNumber) => {
  const tasksInDay = tasks.filter((task)=> {
    if (year === task.infoForCell.startYear) {
      if (month + 1 === task.infoForCell.startMonth) {
        if (dayNumber === task.infoForCell.startDay) {
              return task
          } else {return false}   
        } else {return false}   
      } else {return false}      
    })
    return tasksInDay
}

export const getColorTaskByPriority = (priority) => {
  switch(priority) {
    case 'A': 
      return 'rgb(32, 138, 250)';
    case 'B':
      return 'lightgreen';
    case 'C':
      return 'orange';
    default: 
      return 'rgb(171, 157, 157)';
  }
}