import React, { useEffect, useState } from "react";
import TextField from "@mui/material/TextField";
import { LocalizationProvider } from "@mui/x-date-pickers/LocalizationProvider";
import { DateTimePicker } from "@mui/x-date-pickers/DateTimePicker";
import { AdapterMoment } from "@mui/x-date-pickers/AdapterMoment";
import moment from "moment";





export default function MaterialUIPickers({ task, name, onChange, currentTask }) {
  const [state, setState] = useState(null)
  useEffect(() => {
    if (!task.dateTimeDeadLine) setState(null)
    if (currentTask) setState(moment(task.dateTimeDeadLine).utc())

  }, [task.dateTimeDeadLine, currentTask])

  return (
    <LocalizationProvider
      dateAdapter={AdapterMoment}
      sx={{ width: "100%", fontSize: 5, fontWeight: "200" }}
      adapterLocale={'ru-RU'}
    >
      <DateTimePicker
        disablePast={true}
        showTimeSelect={true}
        minutesStep={60}
        ampm={false}
        ampmInClock={false}
        inputFormat="DD/MM/YY HH:mm"
        renderInput={(params) => {
          return (
            <TextField
              {...params}
              sx={{ width: "auto", fontWeight: "200", fontSize: 5 }}
              name={name}
              value={moment(task.dateTimeDeadLine).utc()}
            />
          )
        }}
        value={state}
        onChange={(newValue) => {
          setState(newValue)
          onChange(newValue, name);
        }}
      />
    </LocalizationProvider>
  );
}
