import { Autocomplete, TextField } from "@mui/material";
import { memo } from "react";

function CustomAutocomplete({ options, onChange, value, name, label, style, getOptionLabel }) {
  return (<>
    <Autocomplete
      id={name}
      freeSolo
      options={options}
      getOptionLabel={getOptionLabel}
      onChange={(e, value) => { onChange(e, value) }}
      name={name}
      value={value}
      renderInput={(params) => <TextField
        style={style}
        label={label}
        state={value}
        {...params} />}
    />
  </>);
}

export default memo(CustomAutocomplete);