import { TableBody} from "@mui/material";
import { memo, useState } from "react";
import { getComparator, stableSort } from "./helpers";
import MyTasksRow from "./MyTasksRow/MyTasksRow";


function MyTasksTableBody({ rows, page, rowsPerPage, order, orderBy, deleteTaskHandler, calendarOpen, deleteCopyTaskHandler, currentTask, setCurrentTask, onChangeCurrentTaskHandler, allUserProjectsForModalTask, onDateChangeEditHandler, editCurrentTaskHandler}) {
  const [isEdit, setIsEdit] = useState(false)
  return (<>
    <TableBody>
      {stableSort(rows, getComparator(order, orderBy))
        .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
        .map((row, index) => {
          return (
            <MyTasksRow
              key={row.id}
              deleteTaskHandler={deleteTaskHandler}
              row={row}
              deleteCopyTaskHandler={deleteCopyTaskHandler}
              calendarOpen={calendarOpen}
              isEdit={isEdit}
              setIsEdit={setIsEdit}
              currentTask={currentTask}
              setCurrentTask={setCurrentTask}
              onChangeCurrentTaskHandler={onChangeCurrentTaskHandler}
              allUserProjectsForModalTask={allUserProjectsForModalTask}
              onDateChangeEditHandler={onDateChangeEditHandler}
              editCurrentTaskHandler={editCurrentTaskHandler}
            />)
        })}
    </TableBody>
  </>);
}

export default memo(MyTasksTableBody)