import { Box } from "@mui/material";
import { memo } from "react";


const WeekDefaultTaskStyles = {
  boxSizing: 'border-box',
  padding: '0 5px',
  borderRadius: '2px',
  border: '1px solid white',
  backgroundColor:'lightgreen',
  height: `100%`,
  width: `100%`,
  zIndex: 5,
  textAlign: 'left',
  overflow: 'hidden',
  textOverflow: 'ellipsis',
}


const DefaultTask = ({ week, top }) => {

  const MonthDefaultTaskStyles = {
    boxSizing: 'border-box',
    position: 'relative',
    height: '35px',
    backgroundColor: 'lightgreen',
    whiteSpace: 'nowrap',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    borderRadius: '10px',
    margin: '5px 3px 0 6px',
    padding: '5px',
    top: top,
    display: 'flex',
    justifyContent: 'flex-start',
    alignItems: 'center',
    zIndex: '5'
  }

  return (<>
    <Box
      sx={week ? WeekDefaultTaskStyles : MonthDefaultTaskStyles}
    >
      <span>
        Задача
      </span>
    </Box>
  </>)
};

export default memo(DefaultTask);