import { Grid } from "@mui/material";
import React, { memo, useCallback, useMemo } from "react";
import { getColorTaskByPriority } from "../../../../../helpers/CalendarHelpers";
import CopyIcon from "../../../UI/CopyIcon/CopyIcon";

const CalendarTask = ({ setCurrentTask, handleOpen, task, setCopyTask, width, left, top, dragTaskHandler, hourFormat, step }) => {

  const color = useMemo(() => {
    return getColorTaskByPriority(task.priority)
  }, [task.priority])

  const styles = useMemo(()=>{
    return {
      boxSizing: 'border-box',
      backgroundColor: color,
      height: `35px`,
      width: `${width - 10}px`,
      position: 'absolute',
      display: 'flex',
      left: left + 5,
      top: top,
      margin: '5px 5px 0 0',
      padding: '5px',
      textAlign: 'left',
      overflow: 'hidden',
      textOverflow: 'ellipsis',
      borderRadius: '10px',
      alignItems: 'center',
      zIndex: '5',
      transition: '0.3s',
      '&:hover': {
        transition: '0.3s',
        cursor: 'pointer',
        boxShadow: 'inset 0 0 100px 100px rgba(255, 255, 255, 0.4)'
      },
    }
  }, [width, left, top, color])

  const onClickTaskHandler = useCallback((e, task) => {
    e.stopPropagation();
    setCurrentTask((prevState) => {
      return {
        ...task,
        infoForCell: {
          ...task.infoForCell,
          endHour: task.infoForCell.endHour + 1
        }
      }
    });
    handleOpen(e)
  },[handleOpen, setCurrentTask])

  const dragLeaveHandler =  useCallback((e) => {
    e.target.style.boxShadow = 'none'
  },[])

  const dragStartHandler =  useCallback((e, task) => {
    setCurrentTask(task);
    setCopyTask(task)
  },[setCurrentTask, setCopyTask])

  const dragEndHandler =  useCallback((e) => {
    e.target.style.boxShadow = 'none'
    setCopyTask(null)
  },[setCopyTask])

  const onClickCopyIconHandler =  useCallback((e) => {
    e.stopPropagation();
    setCopyTask(task)
  },[task, setCopyTask])

  const dragOverHandler =  useCallback((e) => {
    e.preventDefault();
  },[])

  const dropHandler =  useCallback((e, task) => {
    e.preventDefault();
    let hour
    if (hourFormat) {
      hour = task.infoForCell.startHour + (Math.ceil(e.nativeEvent.offsetX / step) - 1)
    } else {
      hour = task.infoForCell.startHour + (Math.ceil(e.nativeEvent.offsetX / step) - 1 + Math.ceil(e.nativeEvent.offsetX / step) - 1)
    }
    dragTaskHandler(task.infoForCell.startDay, hour)
  },[dragTaskHandler, hourFormat, step])


  return (<>
    <Grid
      draggable={true}
      onDragLeave={(e) => { dragLeaveHandler(e) }}
      onDragStart={(e) => { dragStartHandler(e, task) }}
      onDragEnd={(e) => { dragEndHandler(e) }}
      onDrop={(e) => { dropHandler(e, task) }}
      onDragOver={(e) => { dragOverHandler(e) }}
      sx={styles}
      onClick={(e) => { onClickTaskHandler(e, task) }}
    >
      <span style={{ maxWidth: '60%', whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis' }}>
        {task.title}
      </span>
      <CopyIcon
        onClick={(e) => { onClickCopyIconHandler(e)}}
      />
    </Grid>
  </>)
};

export default memo(CalendarTask);