import { FormControl, InputLabel, MenuItem, Select } from '@mui/material';
import { memo } from 'react';

function СustomSelect({ value, onChange, label, variant = 'standard', items, id, defaultValue, name }) {

  return (
    <>
      <FormControl variant={variant} sx={{ m: 0, minWidth: 120 }}>
        <InputLabel id={`${id}-select-label`}>{label}</InputLabel>
        <Select
          labelId={`${id}-select-label`}
          id={`${id}-select`}
          value={value}
          onChange={onChange}
          label={label}
          name={name}
          defaultValue={defaultValue}
        >
          {items.map((item, i) => {
            return (
              <MenuItem
                key={i}
                value={item?.value}
              >{item?.text}</MenuItem>
            )
          })}
        </Select>
      </FormControl>
    </>);
}

export default memo(СustomSelect, (prevProps, nextProps) => {
  if (prevProps.value !== nextProps.value) {
    return false
  } else {
    return true
  }
});