import React,{useEffect, useState} from 'react';
import {  Button, Grid ,Typography,Autocomplete, TextField} from "@mui/material";
import SwitchUserTable from '../SwitchUserTable/SwitchUserTable';




const SwitchUserForm=({submitFormHandler, users})=> {
   const [currentUser, setCurrentUser] = useState(null);
   const [projectsRoles, setProjectsRole] = useState([])

  const onChangeHandle =(user)=>{
    setCurrentUser(user)
    setProjectsRole([])
  }

      
      useEffect(()=>{
        if(currentUser?.members.length>0) {
          for (let member of currentUser.members ) {
            const newProjectRole = {
                "projectName":member.project.title,
                "roleName":member.roleProject
            }
            setProjectsRole([...projectsRoles, newProjectRole ])
          }
        }
      },[ currentUser])

   return (
    <>
        {/* <Box sx={style}> */}
          {users?
              <form  onSubmit={(e)=>submitFormHandler(e,currentUser)}>
              <Grid container direction="column" spacing={2}>
                  <Typography variant="h5" style={{margin: "5px", textAlign: "center"}} >Выберите юзера</Typography>
              
              
              <Autocomplete
                 options={users}
                 onChange={(event,user)=>onChangeHandle(user) }
                 getOptionLabel={(option) => option.displayName}
                 renderInput={(params) => <TextField
                   style={{margin: "5px"}}
                   label={"Юзер"}
                   {...params} />}
               />
          
 
                        {projectsRoles.length>0?
                       <Grid item>
             <SwitchUserTable projectsRoles={projectsRoles}/>
               </Grid>
                        :<></>}
 
            <Grid container direction="row" spacing={2}>
               <Grid item>
                 <Button
                   type="submit"
                   color="primary"
                   variant="contained"
                   sx={{margin:1}}
 
                 >
                   ОК
                 </Button>
 
               </Grid>
              {/* <Grid item>
                <Button
                 onClick={()=>console.log('cancel form')}
                   color="primary"
                   variant="contained"
                 >
                   Отмена
                 </Button>
                </Grid> */}
              </Grid>

              </Grid>
           </form>
             
             : <></>}
         
            {/* </Box> */}
            </>
    )
}

export default SwitchUserForm;
