import {Button, Menu, MenuItem} from "@mui/material";
import { useState, useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import {NavLink, useNavigate} from "react-router-dom";
import { fetchUsersAllFields, fetchUsers, logoutUser } from "../../../store/actions/usersActions";
import SwitchUserModal from "../../SwitchUserModal/SwitchUserModal";

const ProfileBlock = () => {
  const dispatch = useDispatch();
    const navigate = useNavigate()
    const [anchorEl, setAnchorEl] = useState(null);
    const open = Boolean(anchorEl);
    const user = useSelector(state => state.users.user)

    const [openSwitchUser, setOpenSwitchUser] = useState(false);
    const handleCloseSwitchUser = () => setOpenSwitchUser(false);
 
    const handleClick = (event) => {
        setAnchorEl(event.currentTarget);
    };
    const handleClose = () => {
        setAnchorEl(null);
    };

    const handleOpenSwitchUser = () => setOpenSwitchUser(true);

    const logout = () => {
        dispatch(logoutUser(navigate));
        handleClose()
    }
    const switchUser=()=>{
        dispatch(fetchUsersAllFields());
        // dispatch(fetchUsers())
        handleClose()
        handleOpenSwitchUser()
    }


  return <>
      <Button
            color="inherit"
            onClick={handleClick}
            id='test_greetings'
        >
            Hello, {user?.displayName}
        </Button>
        <Menu
            anchorEl={anchorEl}
            open={open}
            onClose={handleClose}

        >
            <MenuItem component={NavLink} to="/profile/test" color="inherit" onClick={handleClose}>Profile</MenuItem>
            <MenuItem onClick={()=>{switchUser()}}>Поменять юзера</MenuItem>
            <MenuItem onClick={()=>{logout()}}>Logout</MenuItem>
        </Menu>
        <SwitchUserModal 
        open={openSwitchUser}
        handleClose={handleCloseSwitchUser} 
        />
  </>
};

export default ProfileBlock;