import { Grid } from "@mui/material";
import React, { memo, useEffect, useState } from "react";
import DefaultTask from "../../DefaultTask/DefaultTask";

const EmptyBox = ({ hourNumber, handleOpen, dayNumber, xs, dragTaskHandler, modal, createTaskInCellHandler, copyTask, createCopyTask }) => {

  const [isThisCell, setIsThisCell] = useState(false)
  useEffect(() => {
    if (!modal) {
      setIsThisCell(false);
    }
  }, [modal])

  const onClickHandler = (e, dayNumber, hour) => {
    if (copyTask) {
      createCopyTask(dayNumber, hour)
    } else {
      createTaskInCellHandler(dayNumber, hour);
      setIsThisCell(true);
      handleOpen(e)
    }
  }
  const dragOverHandler = (e) => {
    e.preventDefault();
  }

  const dropHandler = (e) => {
    e.stopPropagation()
    e.preventDefault();
    dragTaskHandler(dayNumber, hourNumber)
  }

  return (<Grid
    onDragOver={(e) => { dragOverHandler(e) }}
    onDrop={(e) => { dropHandler(e) }}
    onClick={(e) => { onClickHandler(e, dayNumber, hourNumber) }}
    className='test_empty_box'
    item xs={xs} sx={{
      height: '40px',
      backgroundColor: 'rgb(0,0,0,0)',
      zIndex: '6',
      cursor: copyTask ? 'pointer' : 'default'
    }}>
    {isThisCell ?
      <DefaultTask /> : ' '}
  </Grid>)
};

export default memo(EmptyBox, (prevProps, nextProps) => {
  if (!prevProps.modal) return false
  if (nextProps.modal) return true
});