import { useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { useNavigate } from "react-router-dom";
import Loader from "../../components/UI/Loader/Loader";
import UserForm from "../../components/UserForm/UserRegistrationForm";
import { loginUser, registerUser } from "../../store/actions/usersActions";
import styled from "@emotion/styled";
import { Avatar, Container, Typography } from "@mui/material";
import LockIcon from "@mui/icons-material/Lock"; 

const StyledContainer = styled(Container)`
    padding-top: 30px; 
    padding-bottom: 30px;
    box-shadow: 0 18px 30px 0 rgba(0, 0, 0, 0.6);
    border-radius: 6px;
`;

const StyledTitle = styled(Typography)`
    text-align: center;
    font-size: 30px;
    margin-bottom: 30px;
`;

const Register = () => {
    const [state, setState] = useState({
        name: '',
        surname: "",
        email: "",
        number: "",
        password: '',
        // avatar: "",
    });


    const dispatch = useDispatch();
    const { registerError, loading } = useSelector(state => state.users);
    const navigate = useNavigate()

    const fileChangeHandler = (e) => {
        const name = e.target.name;
        const file = e.target.files[0];
        setState(prevState => {
            return {
                ...prevState,
                [name]: file
            }
        })
    }

    const inputChangeHandler = (e) => {
        const { name, value } = e.target;
        setState((prevState) => {
            return {
                ...prevState,
                [name]: value
            }
        });
    };

    const submitHandler = async (e) => {
        e.preventDefault();
        const formData = new FormData();
        Object.keys(state).forEach(key => {
            formData.append(key, state[key]);
        })
        await dispatch(registerUser(formData, navigate));
        await dispatch(loginUser(state, navigate))
    };

    const getFieldError = (fieldname) => {
        return registerError?.errors?.[fieldname]?.message
    }
    return <>
        <StyledContainer component={"section"} maxWidth={"xs"}>
            <Avatar sx={{ m: "0 auto 30px" }}>
                <LockIcon />
            </Avatar>
            <StyledTitle variant={"h1"}>
                Sign Up
            </StyledTitle>
            <UserForm
                onSubmit={submitHandler}
                state={state}
                onChange={inputChangeHandler}
                buttonText={"Sign Up"}
                getFieldError={getFieldError}
                fileChangeHandler={fileChangeHandler}
            />
        </StyledContainer>
        <Loader loading={loading} />
    </>
};

export default Register;