import { Button, Menu, MenuItem } from "@mui/material";
import { useState } from "react";
import { useDispatch } from "react-redux";
import { NavLink, useNavigate } from "react-router-dom";
import { logoutUser } from "../../../store/actions/usersActions";
import HasAccess from "../../UI/HasAccess/HasAccess";

const UserMenu = ({ user }) => {
    const dispatch = useDispatch();
    const navigate = useNavigate()
    const [anchorEl, setAnchorEl] = useState(null);
    const open = Boolean(anchorEl);
    const handleClick = (event) => {
        setAnchorEl(event.currentTarget);
    };
    const handleClose = () => {
        setAnchorEl(null);
    };

    const logout = () => {
        dispatch(logoutUser(navigate));
        handleClose()
    }
    return <>
        <Button
            color="inherit"
            onClick={handleClick}
        >
            Hello, {user?.displayName}
        </Button>
        {/* <HasAccess roles={["admin"]}>
            <Button
                component={NavLink}
                color="inherit"
                to="/admin"
            >
                Admin panel
            </Button>
        </HasAccess> */}

        <Menu
            anchorEl={anchorEl}
            open={open}
            onClose={handleClose}

        >
            <MenuItem onClick={handleClose}>Profile</MenuItem>
            <MenuItem onClick={handleClose}>My account</MenuItem>
            <MenuItem onClick={logout}>Logout</MenuItem>
        </Menu>
    </>
};

export default UserMenu;