import { getCurrentWeekDayString } from '../components/Calendars/WeekCalendar/WeekCalendarBody/Helpers';
import {getWeekFromCurrentDate, getWeekInfoString} from '../helpers/CalendarHelpers';

describe('Получение недели в 7дневном формате', () => {
  test('Получение недели 10 декабря 2022', () => {
      expect(getWeekFromCurrentDate(2022, 11, 10)).toEqual([5,6,7,8,9,10,11]);
  })
  test('Получение недели 1 декабря 2022', () => {
    expect(getWeekFromCurrentDate(2022, 11, 1)).toEqual([28,29,30,1,2,3,4]);
  })
  test('Получение недели 1 октября 2023', () => {
    expect(getWeekFromCurrentDate(2023, 9, 1)).toEqual([25,26,27,28,29,30,1]);
  })
})

describe('Получение информации о неделе', () => {
  test('Получение информации о недели 10 декабря 2022', () => {
      const date = {month: 11, year: 2022, currentDay: 10}
      const week = [5,6,7,8,9,10,11]
      expect(getWeekInfoString(week, date)).toBe("Декабрь 2022");
  })
  test('Получение информации о недели 1 декабря 2022', () => {
    const date = {month: 11, year: 2022, currentDay: 1}
    const week = [28,29,30,1,2,3,4]
    expect(getWeekInfoString(week, date)).toBe("Ноябрь - Декабрь 2022");
  })
  test('Получение информации о недели 30 ноября 2022', () => {
    const date = {month: 10, year: 2022, currentDay: 30}
    const week = [28,29,30,1,2,3,4]
    expect(getWeekInfoString(week, date)).toBe("Ноябрь - Декабрь 2022");
  })
  test('Получение информации о недели 31 декабря 2022', () => {
    const date = {month: 11, year: 2022, currentDay: 31}
    const week = [26,27,28,29,30,31,1]
    expect(getWeekInfoString(week, date)).toBe("Декабрь - Январь 2022");
  })
  test('Получение информации о недели 1 января 2023', () => {
    const date = {month: 0, year: 2023, currentDay: 1}
    const week = [26,27,28,29,30,31,1]
    expect(getWeekInfoString(week, date)).toBe("Декабрь - Январь 2023");
  })
  test('Получение информации о недели 31 января 2023', () => {
    const date = {month: 0, year: 2023, currentDay: 31}
    const week = [30,31,1,2,3,4,5]
    expect(getWeekInfoString(week, date)).toBe("Январь - Февраль 2023");
  })
})

describe('Получение дня недели', () => {
  test('Понедельник', () => {
    expect(getCurrentWeekDayString(0)).toBe('ПН');
  })
  test('Четверг', () => {
    expect(getCurrentWeekDayString(3)).toBe('ЧТ');
  })
  test('Воскресенье', () => {
    expect(getCurrentWeekDayString(6)).toBe('ВС');
  })
  test('Неккоретное значение выше нормы', () => {
    expect(getCurrentWeekDayString(7)).toBe(null);
  })
  test('Неккоретное значение ниже нормы', () => {
    expect(getCurrentWeekDayString(-1)).toBe(null);
  })
})



