import Paper from '@mui/material/Paper';
import MyTasksTableToolbar from '../../components/MyTasksCompoments/MyTasksTableToolbar/MyTasksTableToolbar';
import MyTasksTablePagination from '../../components/MyTasksCompoments/MyTasksTablePagination/MyTasksTablePagination';
import MyTasksTableContainer from '../../components/MyTasksCompoments/MyTasksTableContainer/MyTasksTableContainer';
import { activateCreateCopyTasksMode, fetchAllTasks, sortTaskByProjects, addTask, deleteTask, deleteDateTimeTask, editTask } from '../../store/actions/tasksActions';
import { shallowEqual, useDispatch, useSelector } from 'react-redux';
import { useCallback, useEffect, useState } from 'react';
import { fetchAllUserProjects, fetchProjects } from '../../store/actions/projectsActions';
import moment from 'moment';
import { useNavigate } from 'react-router-dom';

export default function MyTasks() {
  const dispatch = useDispatch();
  const navigate = useNavigate()

  const { user } = useSelector((state) => state.users);
  const { tasks, sortedTasks } = useSelector((state) => state.tasks, shallowEqual);
  const { allUserProjectsForModalTask, projects } = useSelector(state => state.projects, shallowEqual)

  const [newTask, setNewTask] = useState({
    priority: '',
    title: '',
    project: '',
    description: '',
    dateTimeDeadLine: null,
  })

  const [currentTask, setCurrentTask] = useState({
    priority: '',
    title: '',
    project: '',
    description: '',
    dateTimeDeadLine: null,
  })

  const [order, setOrder] = useState('asc');
  const [orderBy, setOrderBy] = useState('createdAt');
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(10);
  const [addFormStatus, setAddFormStatus] = useState(false);
  const [projectIdListForTaskSelect, setProjectIdListForTaskSelect] = useState([]);
  const [activeTasksStatus, setActiveTasksStatus] = useState(false)

  useEffect(() => {
    dispatch(fetchAllTasks());
    dispatch(fetchAllUserProjects())
    dispatch(fetchProjects())
  }, [dispatch]);

  useEffect(() => {
    dispatch(sortTaskByProjects(projectIdListForTaskSelect, activeTasksStatus))
  }, [dispatch, projectIdListForTaskSelect, activeTasksStatus, tasks]);


  const onChangeNewTaskHandler = useCallback((e) => {
    const { value, name } = e.target;
    setNewTask((prevState => {
      return {
        ...prevState,
        [name]: value
      }
    }));
  }, [])

  const onChangeCurrentTaskHandler = useCallback((e) => {
    const { value, name } = e.target;
    setCurrentTask((prevState => {
      return {
        ...prevState,
        [name]: value
      }
    }));
  }, [])

  const onDateChangeEditHandler = useCallback((value, property) => {
    const utcAvoidoffset = moment(value).utcOffset(0, true).format()
    setCurrentTask((prevState => {
      return {
        ...prevState,
        [property]: utcAvoidoffset
      }
    }));
  }, []);

  const onDateChangeHandler = useCallback((value, property) => {
    const utcAvoidoffset = moment(value).utcOffset(0, true).format()
    setNewTask((prevState => {
      return {
        ...prevState,
        [property]: utcAvoidoffset
      }
    }));
  }, []);

  const handleRequestSort = useCallback((event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  }, [order, orderBy]);

  const handleChangePage = useCallback((event, newPage) => {
    setPage(newPage);
  }, []);

  const handleChangeRowsPerPage = useCallback((event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  }, []);

  const createTaskFromButtonHandler = useCallback(() => {
    if (addFormStatus) {
      setNewTask({
        priority: '',
        title: '',
        project: '',
        description: '',
        dateTimeDeadLine: null
      })
    }
    setAddFormStatus((prevState) => { return !prevState })
  }, [addFormStatus])

  const createNewTaskHandler = useCallback(() => {
    const task = {
      ...newTask,
      priority: newTask.priority ? newTask.priority : null,
      project: newTask.project ? newTask.project : null,
      executor: user,
      dateTimeDeadLine: new Date(newTask.dateTimeDeadLine) instanceof Date && !isNaN(new Date(newTask.dateTimeDeadLine)) ? newTask.dateTimeDeadLine : null
    }
    dispatch(addTask(task))
    setNewTask({
      priority: '',
      title: '',
      project: '',
      description: '',
      dateTimeDeadLine: null
    })
    setAddFormStatus((prevState) => { return !prevState })
  }, [dispatch, newTask, user])


  const deleteTaskHandler = useCallback((id) => {
    dispatch(deleteTask(id))
  }, [dispatch])

  const deleteCopyTaskHandler = useCallback((id) => {
    dispatch(deleteDateTimeTask(id))
  }, [dispatch])

  const calendarOpen = useCallback((task) => {
    dispatch(activateCreateCopyTasksMode(task, navigate))
  }, [dispatch, navigate])

  const editCurrentTaskHandler = useCallback(() => {
    const task = {
      ...currentTask,
      priority: currentTask.priority ? currentTask.priority : null,
      project: currentTask.project ? currentTask.project : null,
      executor: user,
      dateTimeDeadLine: new Date(currentTask.dateTimeDeadLine) instanceof Date && !isNaN(new Date(currentTask.dateTimeDeadLine)) ? currentTask.dateTimeDeadLine : null
    }
    dispatch(editTask(task))
    setCurrentTask({
      priority: '',
      title: '',
      project: '',
      description: '',
      dateTimeDeadLine: null
    })
  }, [dispatch, currentTask, user])

  const onCloseFilterByProjects = useCallback((listProjectIds) => {
    setProjectIdListForTaskSelect(listProjectIds)
  }, [])


  return (
    <Paper sx={{ width: '100%', mb: 2 }}>
      <MyTasksTableToolbar
        addFormStatus={addFormStatus}
        createTaskFromButtonHandler={createTaskFromButtonHandler}
        onCloseFilterByProjects={onCloseFilterByProjects}
        projectIdListForTaskSelect={projectIdListForTaskSelect}
        setProjectIdListForTaskSelect={setProjectIdListForTaskSelect}
        projects={projects.projects}
        activeTasksStatus={activeTasksStatus}
        setActiveTasksStatus={setActiveTasksStatus}
      />
      <MyTasksTableContainer
        order={order}
        orderBy={orderBy}
        handleRequestSort={handleRequestSort}
        rows={sortedTasks.length ? sortedTasks : tasks}
        page={page}
        rowsPerPage={rowsPerPage}
        addFormStatus={addFormStatus}
        onChangeNewTaskHandler={onChangeNewTaskHandler}
        newTask={newTask}
        allUserProjectsForModalTask={allUserProjectsForModalTask}
        onDateChangeHandler={onDateChangeHandler}
        createNewTaskHandler={createNewTaskHandler}
        deleteTaskHandler={deleteTaskHandler}
        calendarOpen={calendarOpen}
        deleteCopyTaskHandler={deleteCopyTaskHandler}
        currentTask={currentTask}
        setCurrentTask={setCurrentTask}
        onChangeCurrentTaskHandler={onChangeCurrentTaskHandler}
        onDateChangeEditHandler={onDateChangeEditHandler}
        editCurrentTaskHandler={editCurrentTaskHandler}
      />
      <MyTasksTablePagination
        count={sortedTasks.length ? sortedTasks.length : tasks.length}
        rowsPerPage={rowsPerPage}
        page={page}
        handleChangePage={handleChangePage}
        handleChangeRowsPerPage={handleChangeRowsPerPage}
      />
    </Paper>
  );
}
