export const getCurrentWeekDayString = (dayNumber) => {
  if (dayNumber <= 6 && dayNumber >= 0) {
    return ["ПН", "ВТ", "СР", "ЧТ", "ПТ", "СБ", "ВС"][dayNumber];
  } else {
    return null
  }
}


export const getMonthAndYearToDayColumn = (week, weekDay, month, year) => {
  if (week[0] > week[6]) {
    if (weekDay < week[0]) {
      if (month + 1 === 12) {
        return {month: 0, year: year + 1}
      }
      return {month: month + 1, year: year}
    } else {
      return {month: month, year: year}
    }
  } else {
    return {month: month, year: year}
  }
}
