import express,{Router, Request, Response } from 'express';
import {Task} from '../models/Task';
import {myDataSource} from '../app-data-source';
import { DateTimeTask } from '../models/DateTimeTask';
import {  auth, authAuthorOrExecutorOfDateTimeTask, authAuthorOrExecutorOfTask } from '../helpers';
const router:Router = express.Router();
const dataSource = myDataSource;


/** make copy of task in calendar view */
router.post("/make-copy",auth,authAuthorOrExecutorOfTask, async(req:Request, res:Response):Promise<Response>=>{
    try{
    const {taskId, dateTimeDue, dateTimeStart, authorStatus, executorStatus, task} = req.body;
    if(!task) return res.status(401).send({message:'task with possible user involved is not found'})
        const newDateTimeTask = new DateTimeTask();
        newDateTimeTask.dateTimeStart = dateTimeStart;
        newDateTimeTask.dateTimeDue = dateTimeDue;
        newDateTimeTask.task = taskId;
        await newDateTimeTask.save();
        return res.send({task, message:"copyTask created!"})
    } catch(e) {
        return res.status(502).send({message:(e as Error).message})
    }
} )

/** change date time of copy of task in calendar view */
router.put("/change-copy/:dateTimeTaskId",auth, authAuthorOrExecutorOfTask, async(req:Request, res: Response):Promise<Response>=>{
    try{
    const {dateTimeTaskId} = req.params
    const {executorStatus,authorStatus, task, dateTimeStart, dateTimeDue, description, title, priority, project} = req.body
    if(authorStatus){
        task.title = title;
        task.description = description;
        task.priority= priority;
        await task.save()
    }
    const dateTimeTask = await dataSource
    .createQueryBuilder()
    .select('dateTimeTask')
    .from(DateTimeTask,'dateTimeTask')
    .where("dateTimeTask.id = :dateTimeTaskId",{dateTimeTaskId})
    .getOne()
    if(!dateTimeTask) return res.send({message:"such dateTimeTask does not exists"})
    let allDateTimeTasks = task.dateTimeTasks
    if (allDateTimeTasks.length===1) {
        if(executorStatus && !authorStatus) {
            if(task.dateTimeDeadLine>dateTimeStart && 
                task.dateTimeDeadLine>dateTimeDue)
                 {
                dateTimeTask.dateTimeStart=dateTimeStart
                dateTimeTask.dateTimeDue=dateTimeDue
                await dateTimeTask.save()
                 return res.send({message:"copyTask changed succesfully"})
            }
        }else if(authorStatus){
            dateTimeTask.dateTimeStart=dateTimeStart
            dateTimeTask.dateTimeDue=dateTimeDue
            await dateTimeTask.save()
            return res.send({message:"copyTask changed succesfully"})
        }
    } else if (allDateTimeTasks.length>1) {
        let dateTimeTasks =  task.dateTimeTasks
        dateTimeTasks.sort(function(a:DateTimeTask, b:DateTimeTask) {
            return (a.dateTimeDue > b.dateTimeDue) ? -1 : ((a.dateTimeDue < b.dateTimeDue) ? 1 : 0);
        });
        let latestDueDateCopyTask = dateTimeTasks[0]
        if (latestDueDateCopyTask.id ===dateTimeTaskId)
        if (authorStatus) {
            dateTimeTask.dateTimeStart=dateTimeStart
            dateTimeTask.dateTimeDue=dateTimeDue
            await dateTimeTask.save()
            return res.send({message:"copyTask changed succesfully"})
        }
    }
    dateTimeTask.dateTimeStart=dateTimeStart
    dateTimeTask.dateTimeDue=dateTimeDue
    await dateTimeTask.save()
    task.title = title; 
    task.description = description;
    task.priority = priority;
    task.project = project
    await task.save()
    return res.send({task}) 
} catch(e) {
    return res.status(502).send({message:(e as Error).message})
}
})

/**delete copyTask by dateTimeTaskId */
router.delete('/:dateTimeTaskId',authAuthorOrExecutorOfDateTimeTask, async(req:Request, res:Response):Promise<Response|void>=>{
    try{
    const {authorStatus, executorStatus, task} = req.body
    const {dateTimeTaskId} = req.params
  
    if (!task) return res.status(404).send({message:'task with possible copytask involved is not found'})
    let dateTimeTasks = task?.dateTimeTasks
    if (authorStatus || executorStatus) {

    if (dateTimeTasks.length>1) {
        dateTimeTasks.sort(function(a:DateTimeTask, b:DateTimeTask) {
            return (a.dateTimeDue > b.dateTimeDue) ? -1 : ((a.dateTimeDue < b.dateTimeDue) ? 1 : 0);
        });
        const latestDueDateCopyTask = dateTimeTasks[0]
        await myDataSource
            .createQueryBuilder()
            .delete()
            .from(DateTimeTask)
            .where("id = :dateTimeTaskId", { dateTimeTaskId })
            .execute()
        if (latestDueDateCopyTask.id === dateTimeTaskId) {
            task.dateTimeDeadLine= dateTimeTasks[1].dateTimeDue
            await task.save()
        } else {
            task.dateTimeDeadLine= dateTimeTasks[0].dateTimeDue
        }
        return res.send({message:"copyTask delete succesfully"})
    }
}

    if (dateTimeTasks.length === 1  ) {
        if ( authorStatus) {
            task.dateTimeTasks = []
            await task.save()
            return res.send({message:"copyTask delete succesfully"})
        } else{
            return res.send({message:"not uathorized to delete task"})
        }
    }
} catch(e) {
    return res.status(502).send({message:(e as Error).message})
}
}
)

export default router;
