import { ADD_NEW_TASK_FAILURE, ADD_NEW_TASK_REQUEST, ADD_NEW_TASK_SUCCESS, FETCH_TASKS_FAILURE, FETCH_TASKS_REQUEST, FETCH_TASKS_SUCCESS} from "../actionTypes/tasksTypes";
import axios from '../../axiosPlanner'

const fetchTasksRequest = () => {
  return {type:  FETCH_TASKS_REQUEST}
};

const fetchTasksSuccess = (tasks) => {
  return {type: FETCH_TASKS_SUCCESS, tasks}
};

const fetchTasksFailure = (error) => {
  return {type: FETCH_TASKS_FAILURE, error}
};

export const fetchTasks = () => {
  return async (dispatch) => {
      dispatch(fetchTasksRequest());
      try {
        const response = await axios.get("/tasks");
        dispatch(fetchTasksSuccess(response.data.tasks))
      } catch (error) {
        dispatch(fetchTasksFailure(error.response.data));
      }
  }
}

const addTaskRequest = () => {
  return {type: ADD_NEW_TASK_REQUEST}
};

const addTaskSuccess = () => {
  return {type: ADD_NEW_TASK_SUCCESS}
};

const addTaskFailure = (error) => {
  return {type: ADD_NEW_TASK_FAILURE, error}
};

export const addTask = (task) => {
  return async (dispatch, getState) => {
      dispatch(addTaskRequest());
      const token = getState().users?.user?.token;
      try {
        await axios.post("/tasks", task, {
          headers: {
            'Authorization': 'yjBjcPCQwytwrYo9rRuiK'
          }
        });
        dispatch(addTaskSuccess())
        dispatch(fetchTasks())
      } catch (error) {
        dispatch(addTaskFailure(error.response.data));
      }
  }
}