import { Grid, TextField } from "@mui/material";
import React, { useEffect, useState } from "react";

const CalendarTask = ({year, month, tasks, day, hours, setCurrentTask, onChange, hourFormat}) => {

  const getTaskInDayCell = (tasks, day, hours) => {
    const hour = parseInt(hours.split(':')[0])
    let hourDiffEnd
    let hourDiffStart
    if (hourFormat) {
      hourDiffEnd = hour + 1
    } else {
      hourDiffEnd = hour + 2
    }
    if (hourFormat) {
      hourDiffStart = hour - 1
    } else {
      hourDiffStart = hour - 2
    }
    const tasksCell = tasks.filter(task=> {
    if (year === task.infoForCell.startYear) {
      if (month + 1 === task.infoForCell.startMonth) {
        if (day.dayNumber === task.infoForCell.startDay) {
          if (((task.infoForCell.endHour <= hour || task.infoForCell.startHour <= hour) && (task.infoForCell.endHour > hour))  
          || (task.infoForCell.startHour >= hour  && task.infoForCell.endHour < hourDiffEnd)
          || (task.infoForCell.endMinute <= 59 && task.infoForCell.endHour === hour)) {
              return task
          }
        }
      }      
    }
    })
    return tasksCell
  }
  
  const tasksCell = getTaskInDayCell(tasks, day, hours)

  return (<> 
      {tasksCell.length ? tasksCell.map((task, i)=>
      {
      return (
      <Grid  key={task.id} sx={{backgroundColor: 'lightgreen'}}>
        <TextField 
        id={task.title} 
        variant="standard" 
        value={task.title} 
        name='title' 
        onClick={(e)=>{e.stopPropagation(); setCurrentTask(task)}}
        onChange={onChange}>
        </TextField>
      </Grid>)}
      ) : null }
  </>)
};

export default CalendarTask;