import { myDataSource } from "./app-data-source";
import { User, UserRole } from "./models/User";

import { faker } from '@faker-js/faker';
import { Task } from "./models/Task";



function randomIntFromInterval(min:number, max:number) { 
  return Math.floor(Math.random() * (max - min + 1) + min)
}

const loadFixtures = async () => {
  myDataSource
  .initialize()
  .then(async () => {
    console.log(`
==========================

Data Source has been initialized!

==========================
    `)
    
    const userRoles = [{role: UserRole.DIRECTOR}, {role: UserRole.SUPERUSER}, {role: UserRole.USER}, {role: UserRole.USER}];
    const users = []
    for (let i = 0; i < 4; i++) {
      const name = faker.name.firstName()
      const surname = faker.name.lastName()
      const displayName = name + ' ' + surname[0] + '.'
      const user = new User()
      user.name = name;
      user.surname = surname;
      user.password = '12345qwert';
      user.displayName= displayName;
      user.phone = faker.phone.number('+77#########')
      user.email = faker.internet.email();
      user.role = userRoles[i].role;
      user.generateToken()
      await user.save();
      users.push(user)
    }
    

    })

    

  .catch((err) => {
      console.error("Error during Data Source initialization:", err)
  })
};

loadFixtures()